#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from blackduck.hub_services_helper import HubServicesHelper
from com.synopsys.integration.blackduck.api.generated.discovery import ApiDiscovery

params = {
    'url': configuration.url,
    'username': configuration.username,
    'password': configuration.password,
    'proxyHost': configuration.proxyHost,
    'proxyPort': configuration.proxyPort,
    'proxyUsername': configuration.proxyUsername,
    'proxyPassword': configuration.proxyPassword,
    'trustCertificate': configuration.trustCertificate
}

hub_services_helper = HubServicesHelper(params=params)

print "Checking connection by calling getHubVersion Service"
hub_services_factory = hub_services_helper.get_hub_services_factory()
hub_service = hub_services_factory.createHubService()
liveness = hub_service.getResponse(ApiDiscovery.HEALTH_CHECKS_LIVENESS_LINK_RESPONSE)
print "Connection Successful: Healthy: {0}".format(liveness.healthy)
