/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome.google.analytics;

import com.google.gson.Gson;
import com.synopsys.integration.phonehome.PhoneHomeRequestBody;
import com.synopsys.integration.phonehome.enums.ProductIdEnum;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;

public class GoogleAnalyticsRequestHelper {
    private final Gson gson;
    private final String trackingId;
    private final String customerId;
    private final String hostName;
    private final String artifactId;
    private final String artifactVersion;
    private final ProductIdEnum productId;
    private final String productVersion;
    private final Map<String, String> metaData;

    public GoogleAnalyticsRequestHelper(Gson gson, String trackingId, PhoneHomeRequestBody phoneHomeRequestBody) {
        this.gson = gson;
        this.trackingId = trackingId;
        this.customerId = phoneHomeRequestBody.getCustomerId();
        this.hostName = phoneHomeRequestBody.getHostName();
        this.artifactId = phoneHomeRequestBody.getArtifactId();
        this.artifactVersion = phoneHomeRequestBody.getArtifactVersion();
        this.productId = phoneHomeRequestBody.getProductId();
        this.productVersion = phoneHomeRequestBody.getProductVersion();
        this.metaData = phoneHomeRequestBody.getMetaData();
    }

    public HttpPost createRequest(String url) throws UnsupportedEncodingException {
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.getPayloadDataMap().entrySet()) {
            BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue());
            parameters.add(nameValuePair);
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        return post;
    }

    private Map<String, String> getPayloadDataMap() {
        HashMap<String, String> payloadData = new HashMap<String, String>();
        payloadData.put("v", "1");
        payloadData.put("t", "pageview");
        payloadData.put("cid", this.generateClientId());
        payloadData.put("tid", this.trackingId);
        payloadData.put("dp", "phone-home");
        payloadData.put("cd1", this.customerId);
        payloadData.put("cd7", this.hostName);
        payloadData.put("cd2", this.artifactId);
        payloadData.put("cd3", this.artifactVersion);
        payloadData.put("cd4", this.productId.name());
        payloadData.put("cd5", this.productVersion);
        payloadData.put("cd6", this.gson.toJson(this.metaData));
        return payloadData;
    }

    private String generateClientId() {
        String clientId = !"<unknown>".equals(this.customerId) ? this.customerId : (!"<unknown>".equals(this.hostName) ? this.hostName : "<unknown>");
        byte[] bytesFromString = clientId.getBytes();
        return UUID.nameUUIDFromBytes(bytesFromString).toString();
    }
}

