/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.pdf;

import com.synopsys.integration.pdf.PDFBoxManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;

public class StringManager {
    public static List<String> wrapToCombinedList(String str, int charLimit) throws IOException {
        return StringManager.wrapToCombinedList(PDFBoxManager.DEFAULT_FONT, 10.0f, str, charLimit);
    }

    public static List<String> wrapToCombinedList(PDFont font, float fontSize, String str, int charLimit) throws IOException {
        ArrayList<String> subWords = new ArrayList<String>(Arrays.asList(str.split(" ")));
        String previousBrokenWord = "";
        for (int i = 0; i < subWords.size(); ++i) {
            String currentSubWord = subWords.get(i);
            float stringWidth = StringManager.getStringWidth(font, fontSize, currentSubWord);
            if (!(stringWidth > (float)charLimit) || previousBrokenWord.equals(currentSubWord)) continue;
            previousBrokenWord = currentSubWord;
            subWords.remove(currentSubWord);
            List<String> brokenStrings = StringManager.breakWrapString(font, fontSize, currentSubWord, charLimit);
            subWords.addAll(i, brokenStrings);
        }
        ArrayList<String> finalStrings = new ArrayList<String>();
        String currentStringCombo = "";
        for (String currentSubWord : subWords) {
            if (StringUtils.isBlank((CharSequence)currentSubWord)) continue;
            if (StringManager.getStringWidth(font, fontSize, currentStringCombo) + StringManager.getStringWidth(font, fontSize, currentSubWord) > (float)charLimit) {
                if (StringUtils.isBlank((CharSequence)currentStringCombo)) {
                    finalStrings.add(currentSubWord);
                    continue;
                }
                finalStrings.add(currentStringCombo);
                currentStringCombo = currentSubWord;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)currentStringCombo)) {
                currentStringCombo = currentSubWord;
                continue;
            }
            currentStringCombo = currentStringCombo + " " + currentSubWord;
        }
        if (currentStringCombo.length() > 0) {
            finalStrings.add(currentStringCombo);
        }
        return finalStrings;
    }

    public static float getStringWidth(String text) throws IOException {
        String fixedText = StringManager.replaceUnsupportedCharacters(text);
        float rawLength = PDFBoxManager.DEFAULT_FONT.getStringWidth(fixedText);
        return rawLength * 0.010416667f;
    }

    public static float getStringWidth(PDFont font, float fontSize, String text) throws IOException {
        String fixedText = StringManager.replaceUnsupportedCharacters(text);
        float rawLength = font.getStringWidth(fixedText);
        return rawLength * (fontSize / 960.0f);
    }

    public static List<String> breakWrapString(PDFont font, float fontSize, String str, int charLimit) throws IOException {
        int lastBreak = 0;
        float maxLengthCounter = 0.0f;
        int strLen = str.length();
        ArrayList<String> brokenUpStrings = new ArrayList<String>();
        for (int i = 1; i < strLen; ++i) {
            if (!StringUtils.isAlphanumeric((CharSequence)(str.charAt(i) + "")) || maxLengthCounter >= (float)charLimit) {
                brokenUpStrings.add(str.substring(lastBreak, i));
                lastBreak = i;
                maxLengthCounter = 0.0f;
                continue;
            }
            maxLengthCounter = StringManager.getStringWidth(font, fontSize, str.substring(lastBreak, i));
        }
        if (brokenUpStrings.isEmpty() || maxLengthCounter > 0.0f && maxLengthCounter < (float)charLimit) {
            brokenUpStrings.add(str.substring(lastBreak, strLen));
        }
        ArrayList<String> finalStrings = new ArrayList<String>();
        String currentStringCombo = "";
        for (String currentBrokenString : brokenUpStrings) {
            if (StringManager.getStringWidth(font, fontSize, currentStringCombo) + StringManager.getStringWidth(font, fontSize, currentBrokenString) > (float)charLimit) {
                finalStrings.add(currentStringCombo);
                currentStringCombo = currentBrokenString;
                continue;
            }
            currentStringCombo = currentStringCombo + currentBrokenString;
        }
        if (currentStringCombo.length() > 0) {
            finalStrings.add(currentStringCombo);
        }
        return finalStrings;
    }

    public static String replaceUnsupportedCharacters(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (WinAnsiEncoding.INSTANCE.contains((int)text.charAt(i))) {
                builder.append(text.charAt(i));
                continue;
            }
            builder.append("?");
        }
        return builder.toString();
    }
}

