/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner;

import com.synopsys.integration.blackduck.configuration.HubServerConfig;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.signaturescanner.ScanJob;
import com.synopsys.integration.blackduck.signaturescanner.ScanJobOutput;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommand;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommandOutput;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommandRunner;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPaths;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.blackduck.signaturescanner.command.ScannerZipInstaller;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.OperatingSystemType;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ScanJobManager {
    private final IntLogger logger;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final ScannerZipInstaller scannerZipInstaller;
    private final ScanPathsUtility scanPathsUtility;
    private final ScanCommandRunner scanCommandRunner;

    public static ScanJobManager createDefaultScanManager(IntLogger logger, HubServerConfig hubServerConfig) throws EncryptionException {
        IntEnvironmentVariables intEnvironmentVariables = new IntEnvironmentVariables();
        OperatingSystemType operatingSystemType = OperatingSystemType.determineFromSystem();
        ScanPathsUtility scanPathsUtility = new ScanPathsUtility(logger, intEnvironmentVariables, operatingSystemType);
        ScanCommandRunner scanCommandRunner = new ScanCommandRunner(logger, intEnvironmentVariables, scanPathsUtility);
        ScannerZipInstaller scannerZipInstaller = ScannerZipInstaller.defaultUtility(logger, hubServerConfig, scanPathsUtility, operatingSystemType);
        return new ScanJobManager(logger, intEnvironmentVariables, scannerZipInstaller, scanPathsUtility, scanCommandRunner);
    }

    public static ScanJobManager createScanManagerWithNoInstaller(IntLogger logger, IntEnvironmentVariables intEnvironmentVariables, ScanPathsUtility scanPathsUtility, ScanCommandRunner scanCommandRunner) {
        return new ScanJobManager(logger, intEnvironmentVariables, null, scanPathsUtility, scanCommandRunner);
    }

    public static ScanJobManager createFullScanManager(IntLogger logger, IntEnvironmentVariables intEnvironmentVariables, ScannerZipInstaller scannerZipInstaller, ScanPathsUtility scanPathsUtility, ScanCommandRunner scanCommandRunner) {
        return new ScanJobManager(logger, intEnvironmentVariables, scannerZipInstaller, scanPathsUtility, scanCommandRunner);
    }

    public ScanJobManager(IntLogger logger, IntEnvironmentVariables intEnvironmentVariables, ScannerZipInstaller scannerZipInstaller, ScanPathsUtility scanPathsUtility, ScanCommandRunner scanCommandRunner) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.scannerZipInstaller = scannerZipInstaller;
        this.scanPathsUtility = scanPathsUtility;
        this.scanCommandRunner = scanCommandRunner;
    }

    public ScanJobOutput executeScans(ScanJob scanJob) throws IOException, HubIntegrationException {
        if (this.scannerZipInstaller != null) {
            File installDirectory = scanJob.getSignatureScannerInstallDirectory();
            if (!installDirectory.exists()) {
                this.scannerZipInstaller.installOrUpdateScanner(installDirectory);
            } else {
                try {
                    ScanPaths scanPaths = this.scanPathsUtility.determineSignatureScannerPaths(installDirectory);
                    if (scanPaths.isManagedByLibrary()) {
                        this.scannerZipInstaller.installOrUpdateScanner(installDirectory);
                    }
                }
                catch (HubIntegrationException e) {
                    this.scannerZipInstaller.installOrUpdateScanner(installDirectory);
                }
            }
        }
        List<ScanCommand> scanCommands = scanJob.createScanCommands(this.scanPathsUtility);
        List<ScanCommandOutput> scanCommandOutputs = this.scanCommandRunner.executeScans(scanCommands, scanJob.isCleanupOutput());
        return new ScanJobOutput(scanCommandOutputs);
    }
}

