/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.generated.component.ActivityDataView;
import com.synopsys.integration.blackduck.api.generated.component.ReviewedDetails;
import com.synopsys.integration.blackduck.api.generated.component.VersionBomLicenseView;
import com.synopsys.integration.blackduck.api.generated.component.VersionBomOriginView;
import com.synopsys.integration.blackduck.api.generated.enumeration.MatchedFileUsagesType;
import com.synopsys.integration.blackduck.api.generated.enumeration.PolicySummaryStatusType;
import com.synopsys.integration.blackduck.api.generated.enumeration.RiskCountType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VersionBomComponentMatchType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VersionBomComponentReviewStatusType;
import com.synopsys.integration.blackduck.api.generated.view.MatchedFileView;
import com.synopsys.integration.blackduck.api.generated.view.VersionBomComponentView;
import com.synopsys.integration.blackduck.service.model.MatchedFilesModel;
import com.synopsys.integration.blackduck.service.model.RiskProfileCounts;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VersionBomComponentModel {
    private final VersionBomComponentView component;
    private final List<MatchedFilesModel> matchedFiles;

    public VersionBomComponentModel(VersionBomComponentView component, List<MatchedFileView> matchedFiles) {
        this.component = component;
        this.matchedFiles = this.getMatchedFilesModel(matchedFiles);
    }

    public ActivityDataView getActivityData() {
        return this.component.activityData;
    }

    public RiskProfileCounts getActivityRiskProfile() {
        return new RiskProfileCounts(this.component.activityRiskProfile);
    }

    public boolean hasActivityRisk() {
        return this.hasRisk(this.getActivityRiskProfile());
    }

    public String getComponent() {
        return this.component.component;
    }

    public String getComponentName() {
        return this.component.componentName;
    }

    public String getComponentVersion() {
        return this.component.componentVersion;
    }

    public String getComponentVersionName() {
        return this.component.componentVersionName;
    }

    public RiskProfileCounts getLicenseRiskProfile() {
        return new RiskProfileCounts(this.component.licenseRiskProfile);
    }

    public boolean hasLicenseRisk() {
        return this.hasRisk(this.getLicenseRiskProfile());
    }

    public List<VersionBomLicenseView> getLicenses() {
        return this.component.licenses;
    }

    public RiskProfileCounts getOperationalRiskProfile() {
        return new RiskProfileCounts(this.component.operationalRiskProfile);
    }

    public boolean hasOperationalRisk() {
        return this.hasRisk(this.getOperationalRiskProfile());
    }

    public List<VersionBomOriginView> getOrigins() {
        return this.component.origins;
    }

    public List<VersionBomComponentMatchType> getMatchTypes() {
        return this.component.matchTypes;
    }

    public Date getReleasedOn() {
        return this.component.releasedOn;
    }

    public RiskProfileCounts getSecurityRiskProfile() {
        return new RiskProfileCounts(this.component.securityRiskProfile);
    }

    public boolean hasSecurityRisk() {
        return this.hasRisk(this.getSecurityRiskProfile());
    }

    public List<MatchedFileUsagesType> getUsages() {
        return this.component.usages;
    }

    public RiskProfileCounts getVersionRiskProfile() {
        return new RiskProfileCounts(this.component.versionRiskProfile);
    }

    public boolean hasVersionRisk() {
        return this.hasRisk(this.getVersionRiskProfile());
    }

    public VersionBomComponentReviewStatusType getReviewStatus() {
        return this.component.reviewStatus;
    }

    public ReviewedDetails getReviewedDetails() {
        return this.component.reviewedDetails;
    }

    public PolicySummaryStatusType getApprovalStatus() {
        return this.component.approvalStatus;
    }

    public List<MatchedFilesModel> getMatchedFiles() {
        return this.matchedFiles;
    }

    private boolean hasRisk(RiskProfileCounts counts) {
        return counts.getCount(RiskCountType.LOW) + counts.getCount(RiskCountType.MEDIUM) + counts.getCount(RiskCountType.HIGH) > 0;
    }

    private List<MatchedFilesModel> getMatchedFilesModel(List<MatchedFileView> matchedFiles) {
        ArrayList<MatchedFilesModel> matchedFileModels = new ArrayList<MatchedFilesModel>(matchedFiles.size());
        for (MatchedFileView matchedFile : matchedFiles) {
            matchedFileModels.add(new MatchedFilesModel(matchedFile));
        }
        return matchedFileModels;
    }
}

