/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.view.IssueView;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.body.StringBodyContent;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;

public class IssueService
extends DataService {
    public IssueService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
    }

    public String createIssue(IssueView issueItem, String uri) throws IntegrationException {
        String json = this.hubService.convertToJson(issueItem);
        Request request = RequestFactory.createCommonPostRequestBuilder(json).uri(uri).build();
        return this.hubService.executePostRequestAndRetrieveURL(request);
    }

    public void updateIssue(IssueView issueItem, String uri) throws IntegrationException {
        String json = this.hubService.convertToJson(issueItem);
        Request request = new Request.Builder(uri).method(HttpMethod.PUT).bodyContent(new StringBodyContent(json)).build();
        try {
            Response response = this.hubService.executeRequest(request);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public void deleteIssue(IssueView issueItem) throws IntegrationException {
        String codeLocationItemUrl = this.hubService.getHref(issueItem);
        this.deleteIssue(codeLocationItemUrl);
    }

    public void deleteIssue(String issueItemUri) throws IntegrationException {
        Request request = new Request.Builder(issueItemUri).method(HttpMethod.DELETE).build();
        try {
            Response response = this.hubService.executeRequest(request);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }
}

