/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.google.gson.JsonElement;
import com.synopsys.integration.blackduck.api.generated.component.RemediationOptionsView;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.ComponentSearchResultView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentView;
import com.synopsys.integration.blackduck.api.generated.view.VulnerabilityV2View;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.model.ComponentVersionVulnerabilities;
import com.synopsys.integration.blackduck.service.model.HubQuery;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class ComponentService
extends DataService {
    public static final String REMEDIATING_LINK = "remediating";

    public ComponentService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
    }

    public ComponentVersionView getComponentVersion(ExternalId externalId) throws IntegrationException {
        for (ComponentVersionView componentVersion : this.getAllComponentVersions(externalId)) {
            if (!componentVersion.versionName.equals(externalId.version)) continue;
            return componentVersion;
        }
        String errMsg = "Could not find version " + externalId.version + " of component " + externalId.createHubOriginId();
        this.logger.error(errMsg);
        throw new HubIntegrationException(errMsg);
    }

    public List<ComponentVersionView> getAllComponentVersions(ExternalId externalId) throws IntegrationException {
        ComponentSearchResultView componentSearchView = this.getExactComponentMatch(externalId);
        ComponentView componentView = this.hubService.getResponse(componentSearchView.component, ComponentView.class);
        List<ComponentVersionView> componentVersionViews = this.hubService.getAllResponses(componentView, ComponentView.VERSIONS_LINK_RESPONSE);
        return componentVersionViews;
    }

    public ComponentSearchResultView getExactComponentMatch(ExternalId externalId) throws IntegrationException {
        List<ComponentSearchResultView> allComponents = this.getAllComponents(externalId);
        String hubOriginIdToMatch = externalId.createHubOriginId();
        for (ComponentSearchResultView componentItem : allComponents) {
            if (null == hubOriginIdToMatch || !hubOriginIdToMatch.equals(componentItem.originId)) continue;
            return componentItem;
        }
        throw new HubIntegrationException("Couldn't find an exact component that matches " + hubOriginIdToMatch);
    }

    public List<ComponentSearchResultView> getAllComponents(ExternalId externalId) throws IntegrationException {
        String forge = externalId.forge.getName();
        String hubOriginId = externalId.createHubOriginId();
        String componentQuery = String.format("%s|%s", forge, hubOriginId);
        Optional<HubQuery> hubQuery = HubQuery.createQuery("id", componentQuery);
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(hubQuery);
        List<ComponentSearchResultView> allComponents = this.hubService.getAllResponses(ApiDiscovery.COMPONENTS_LINK_RESPONSE, requestBuilder);
        return allComponents;
    }

    public List<VulnerabilityV2View> getVulnerabilitiesFromComponentVersion(ExternalId externalId) throws IntegrationException {
        return this.getComponentVersionVulnerabilities(externalId).getVulnerabilities();
    }

    public ComponentVersionVulnerabilities getComponentVersionVulnerabilities(ExternalId externalId) throws IntegrationException {
        ComponentSearchResultView componentSearchView = this.getExactComponentMatch(externalId);
        String componentVersionURL = componentSearchView.version;
        if (null != componentVersionURL) {
            ComponentVersionView componentVersion = this.hubService.getResponse(componentVersionURL, ComponentVersionView.class);
            return this.getComponentVersionVulnerabilities(componentVersion);
        }
        throw new HubIntegrationException("Couldn't get a componentVersion url from the component matching " + externalId.createExternalId());
    }

    public ComponentVersionVulnerabilities getComponentVersionVulnerabilities(ComponentVersionView componentVersion) throws IntegrationException {
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder().mimeType("application/vnd.blackducksoftware.list-1+json");
        List<VulnerabilityV2View> vulnerabilityList = this.hubService.getAllResponses(componentVersion, ComponentVersionView.VULNERABILITIES_LINK_RESPONSE, requestBuilder);
        return new ComponentVersionVulnerabilities(componentVersion, vulnerabilityList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemediationOptionsView getRemediationInformation(ComponentVersionView componentVersionView) throws IntegrationException {
        String href = this.hubService.getHref(componentVersionView);
        try {
            String remediatingURL = href + "/" + REMEDIATING_LINK;
            try (Response response = this.hubService.executeGetRequest(remediatingURL);){
                JsonElement jsonElement = this.hubService.getJsonParser().parse(response.getContentString());
                RemediationOptionsView remediationOptionsView = this.hubService.getGson().fromJson(jsonElement, RemediationOptionsView.class);
                return remediationOptionsView;
            }
            catch (IOException ioException) {
                throw new IntegrationException(ioException);
            }
        }
        catch (Exception genericException) {
            throw new IntegrationException(genericException);
        }
    }
}

