/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome;

import com.synopsys.integration.phonehome.enums.ProductIdEnum;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class PhoneHomeRequestBody {
    public static final PhoneHomeRequestBody DO_NOT_PHONE_HOME = null;
    private final String customerId;
    private final String hostName;
    private final String artifactId;
    private final String artifactVersion;
    private final ProductIdEnum productId;
    private final String productVersion;
    private final Map<String, String> metaData;

    private PhoneHomeRequestBody(Builder builder) {
        this.customerId = builder.getCustomerId();
        this.hostName = builder.getHostName();
        this.artifactId = builder.getArtifactId();
        this.artifactVersion = builder.getArtifactVersion();
        this.productId = builder.getProductId();
        this.productVersion = builder.getProductVersion();
        this.metaData = Collections.unmodifiableMap(builder.getMetaData());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public ProductIdEnum getProductId() {
        return this.productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public static class Builder {
        public static final String UNKNOWN_ID = "<unknown>";
        private String customerId;
        private String hostName;
        private String artifactId;
        private String artifactVersion;
        private ProductIdEnum productId;
        private String productVersion;
        private final Map<String, String> metaData = new HashMap<String, String>();

        public PhoneHomeRequestBody build() throws IllegalStateException {
            this.validateRequiredParam(this.customerId, "customerId");
            this.validateRequiredParam(this.hostName, "hostName");
            this.validateRequiredParam(this.artifactId, "artifactId");
            this.validateRequiredParam(this.artifactVersion, "artifactVersion");
            if (this.productId == null) {
                throw new IllegalStateException("Required parameter 'productId' is not set");
            }
            this.validateRequiredParam(this.productVersion, "productVersion");
            return new PhoneHomeRequestBody(this);
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getArtifactVersion() {
            return this.artifactVersion;
        }

        public void setArtifactVersion(String artifactVersion) {
            this.artifactVersion = artifactVersion;
        }

        public ProductIdEnum getProductId() {
            return this.productId;
        }

        public void setProductId(ProductIdEnum productId) {
            this.productId = productId;
        }

        public String getProductVersion() {
            return this.productVersion;
        }

        public void setProductVersion(String productVersion) {
            this.productVersion = productVersion;
        }

        public Map<String, String> getMetaData() {
            return this.metaData;
        }

        public void addToMetaData(String key, String value) {
            this.metaData.put(key, value);
        }

        public String md5Hash(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashedBytes = md.digest(string.getBytes("UTF-8"));
            return DigestUtils.md5Hex((byte[])hashedBytes);
        }

        private void validateRequiredParam(String param, String paramName) throws IllegalStateException {
            if (StringUtils.isBlank((CharSequence)param)) {
                throw new IllegalStateException("Required parameter '" + paramName + "' is not set");
            }
        }
    }
}

