/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome;

import com.google.gson.Gson;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.phonehome.PhoneHomeRequestBody;
import com.synopsys.integration.phonehome.exception.PhoneHomeException;
import com.synopsys.integration.phonehome.google.analytics.GoogleAnalyticsRequestHelper;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class PhoneHomeClient {
    public static final String BLACKDUCK_SKIP_PHONE_HOME_VARIABLE = "BLACKDUCK_SKIP_PHONE_HOME";
    public static final String BLACKDUCK_PHONE_HOME_URL_OVERRIDE_VARIABLE = "BLACKDUCK_PHONE_HOME_URL_OVERRIDE";
    public static final String SKIP_PHONE_HOME_VARIABLE = "SYNOPSYS_SKIP_PHONE_HOME";
    public static final String PHONE_HOME_URL_OVERRIDE_VARIABLE = "SYNOPSYS_PHONE_HOME_URL_OVERRIDE";
    private final String googleAnalyticsTrackingId;
    private final HttpClientBuilder httpClientBuilder;
    private final IntLogger logger;
    private final Gson gson;
    private String phoneHomeBackendUrl;

    public PhoneHomeClient(String googleAnalyticsTrackingId, IntLogger logger) {
        this(googleAnalyticsTrackingId, logger, PhoneHomeClient.createInitialRequestConfigBuilder(10, Optional.empty()).build());
    }

    public PhoneHomeClient(String googleAnalyticsTrackingId, IntLogger logger, Gson gson) {
        this(googleAnalyticsTrackingId, logger, PhoneHomeClient.createInitialRequestConfigBuilder(10, Optional.empty()).build(), gson);
    }

    public PhoneHomeClient(String googleAnalyticsTrackingId, IntLogger logger, RequestConfig httpRequestConfig) {
        this(googleAnalyticsTrackingId, logger, httpRequestConfig, new Gson());
    }

    public PhoneHomeClient(String googleAnalyticsTrackingId, IntLogger logger, RequestConfig httpRequestConfig, Gson gson) {
        this(googleAnalyticsTrackingId, logger, HttpClientBuilder.create().setDefaultRequestConfig(httpRequestConfig), gson);
    }

    public PhoneHomeClient(String googleAnalyticsTrackingId, IntLogger logger, HttpClientBuilder httpClientBuilder) {
        this(googleAnalyticsTrackingId, logger, httpClientBuilder, new Gson());
    }

    public PhoneHomeClient(String googleAnalyticsTrackingId, IntLogger logger, HttpClientBuilder httpClientBuilder, Gson gson) {
        this.googleAnalyticsTrackingId = googleAnalyticsTrackingId;
        this.httpClientBuilder = httpClientBuilder;
        this.logger = logger;
        this.gson = gson;
        this.phoneHomeBackendUrl = "https://www.google-analytics.com/collect";
    }

    public void postPhoneHomeRequest(PhoneHomeRequestBody phoneHomeRequestBody, Map<String, String> environmentVariables) throws PhoneHomeException {
        if (this.skipPhoneHome(environmentVariables)) {
            this.logger.debug("Skipping phone home");
            return;
        }
        if (phoneHomeRequestBody == null) {
            throw new PhoneHomeException("The request body must not be null.");
        }
        this.checkOverridePhoneHomeUrl(environmentVariables);
        this.logger.debug("Phoning home to " + this.phoneHomeBackendUrl);
        try (CloseableHttpClient client = this.httpClientBuilder.build();){
            GoogleAnalyticsRequestHelper requestHelper = new GoogleAnalyticsRequestHelper(this.gson, this.googleAnalyticsTrackingId, phoneHomeRequestBody);
            HttpPost request = requestHelper.createRequest(this.phoneHomeBackendUrl);
            CloseableHttpResponse response = client.execute(request);
            this.logger.trace("Response Code: " + response.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            throw new PhoneHomeException(e.getMessage(), e);
        }
    }

    public static RequestConfig.Builder createInitialRequestConfigBuilder(int timeoutSeconds, Optional<HttpHost> proxyHost) {
        int timeoutInMillis = timeoutSeconds * 1000;
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectionRequestTimeout(timeoutInMillis);
        builder.setConnectTimeout(timeoutInMillis);
        builder.setSocketTimeout(timeoutInMillis);
        if (proxyHost.isPresent()) {
            builder.setProxy(proxyHost.get());
        }
        return builder;
    }

    private boolean skipPhoneHome(Map<String, String> environmentVariables) {
        if (environmentVariables.containsKey(SKIP_PHONE_HOME_VARIABLE) || environmentVariables.containsKey(BLACKDUCK_SKIP_PHONE_HOME_VARIABLE)) {
            String valueString = environmentVariables.get(SKIP_PHONE_HOME_VARIABLE);
            if (StringUtils.isBlank((CharSequence)valueString)) {
                valueString = environmentVariables.get(BLACKDUCK_SKIP_PHONE_HOME_VARIABLE);
            }
            return BooleanUtils.toBoolean((String)valueString);
        }
        return false;
    }

    private void checkOverridePhoneHomeUrl(Map<String, String> environmentVariables) {
        if (environmentVariables.containsKey(PHONE_HOME_URL_OVERRIDE_VARIABLE) || environmentVariables.containsKey(BLACKDUCK_PHONE_HOME_URL_OVERRIDE_VARIABLE)) {
            String overrideUrl = environmentVariables.get(PHONE_HOME_URL_OVERRIDE_VARIABLE);
            if (StringUtils.isBlank((CharSequence)overrideUrl)) {
                overrideUrl = environmentVariables.get(BLACKDUCK_PHONE_HOME_URL_OVERRIDE_VARIABLE);
            }
            if (StringUtils.isNotBlank((CharSequence)overrideUrl)) {
                this.phoneHomeBackendUrl = overrideUrl;
                this.logger.debug("Overriding Phone-Home URL: " + overrideUrl);
            }
        }
    }
}

