/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio.graph;

import com.synopsys.integration.hub.bdio.graph.DependencyGraph;
import com.synopsys.integration.hub.bdio.graph.DependencyGraphCombiner;
import com.synopsys.integration.hub.bdio.graph.MutableDependencyGraph;
import com.synopsys.integration.hub.bdio.model.dependency.Dependency;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MutableMapDependencyGraph
implements MutableDependencyGraph {
    private final Set<ExternalId> rootDependencies = new HashSet<ExternalId>();
    private final Map<ExternalId, Dependency> dependencies = new HashMap<ExternalId, Dependency>();
    private final Map<ExternalId, Set<ExternalId>> relationships = new HashMap<ExternalId, Set<ExternalId>>();
    private final DependencyGraphCombiner dependencyGraphCombiner = new DependencyGraphCombiner();

    @Override
    public void addGraphAsChildrenToRoot(DependencyGraph sourceGraph) {
        this.dependencyGraphCombiner.addGraphAsChildrenToRoot(this, sourceGraph);
    }

    @Override
    public void addGraphAsChildrenToParent(Dependency parent, DependencyGraph sourceGraph) {
        this.dependencyGraphCombiner.addGraphAsChildrenToParent(this, parent, sourceGraph);
    }

    @Override
    public boolean hasDependency(ExternalId dependency) {
        return this.dependencies.containsKey(dependency);
    }

    @Override
    public boolean hasDependency(Dependency dependency) {
        return this.dependencies.containsKey(dependency.externalId);
    }

    @Override
    public Dependency getDependency(ExternalId dependency) {
        if (this.dependencies.containsKey(dependency)) {
            return this.dependencies.get(dependency);
        }
        return null;
    }

    @Override
    public Set<Dependency> getChildrenForParent(ExternalId parent) {
        Set<ExternalId> childIds = this.getChildrenExternalIdsForParent(parent);
        return this.dependenciesFromExternalIds(childIds);
    }

    @Override
    public Set<Dependency> getParentsForChild(ExternalId child) {
        Set<ExternalId> parentIds = this.getParentExternalIdsForChild(child);
        return this.dependenciesFromExternalIds(parentIds);
    }

    @Override
    public Set<ExternalId> getChildrenExternalIdsForParent(ExternalId parent) {
        HashSet<ExternalId> children = new HashSet<ExternalId>();
        if (this.relationships.containsKey(parent)) {
            for (ExternalId id : this.relationships.get(parent)) {
                children.add(id);
            }
        }
        return children;
    }

    @Override
    public Set<ExternalId> getParentExternalIdsForChild(ExternalId child) {
        HashSet<ExternalId> parents = new HashSet<ExternalId>();
        for (ExternalId parentId : this.relationships.keySet()) {
            for (ExternalId childId : this.relationships.get(parentId)) {
                if (!childId.equals(child)) continue;
                parents.add(parentId);
            }
        }
        return parents;
    }

    @Override
    public Set<Dependency> getChildrenForParent(Dependency parent) {
        return this.getChildrenForParent(parent.externalId);
    }

    @Override
    public Set<Dependency> getParentsForChild(Dependency child) {
        return this.getParentsForChild(child.externalId);
    }

    @Override
    public Set<ExternalId> getChildrenExternalIdsForParent(Dependency parent) {
        return this.getChildrenExternalIdsForParent(parent.externalId);
    }

    @Override
    public Set<ExternalId> getParentExternalIdsForChild(Dependency child) {
        return this.getParentExternalIdsForChild(child.externalId);
    }

    @Override
    public void addParentWithChild(Dependency parent, Dependency child) {
        this.ensureDependencyAndRelationshipExists(parent);
        this.ensureDependencyExists(child);
        this.addRelationship(parent, child);
    }

    @Override
    public void addChildWithParent(Dependency child, Dependency parent) {
        this.addParentWithChild(parent, child);
    }

    @Override
    public void addParentWithChildren(Dependency parent, List<Dependency> children) {
        this.ensureDependencyAndRelationshipExists(parent);
        for (Dependency child : children) {
            this.ensureDependencyExists(child);
            this.addRelationship(parent, child);
        }
    }

    @Override
    public void addChildWithParents(Dependency child, List<Dependency> parents) {
        this.ensureDependencyExists(child);
        for (Dependency parent : parents) {
            this.ensureDependencyAndRelationshipExists(parent);
            this.addRelationship(parent, child);
        }
    }

    @Override
    public void addParentWithChildren(Dependency parent, Set<Dependency> children) {
        this.ensureDependencyAndRelationshipExists(parent);
        for (Dependency child : children) {
            this.ensureDependencyExists(child);
            this.addRelationship(parent, child);
        }
    }

    @Override
    public void addChildWithParents(Dependency child, Set<Dependency> parents) {
        this.ensureDependencyExists(child);
        for (Dependency parent : parents) {
            this.ensureDependencyAndRelationshipExists(parent);
            this.addRelationship(parent, child);
        }
    }

    @Override
    public void addParentWithChildren(Dependency parent, Dependency ... children) {
        this.addParentWithChildren(parent, Arrays.asList(children));
    }

    @Override
    public void addChildWithParents(Dependency child, Dependency ... parents) {
        this.addChildWithParents(child, Arrays.asList(parents));
    }

    @Override
    public Set<ExternalId> getRootDependencyExternalIds() {
        HashSet<ExternalId> copy = new HashSet<ExternalId>();
        copy.addAll(this.rootDependencies);
        return copy;
    }

    @Override
    public Set<Dependency> getRootDependencies() {
        return this.dependenciesFromExternalIds(this.getRootDependencyExternalIds());
    }

    @Override
    public void addChildToRoot(Dependency child) {
        this.ensureDependencyExists(child);
        this.rootDependencies.add(child.externalId);
    }

    @Override
    public void addChildrenToRoot(List<Dependency> children) {
        for (Dependency child : children) {
            this.addChildToRoot(child);
        }
    }

    @Override
    public void addChildrenToRoot(Set<Dependency> children) {
        for (Dependency child : children) {
            this.addChildToRoot(child);
        }
    }

    @Override
    public void addChildrenToRoot(Dependency ... children) {
        for (Dependency child : children) {
            this.addChildToRoot(child);
        }
    }

    private void ensureDependencyExists(Dependency dependency) {
        if (!this.dependencies.containsKey(dependency.externalId)) {
            this.dependencies.put(dependency.externalId, dependency);
        }
    }

    private void ensureDependencyAndRelationshipExists(Dependency dependency) {
        this.ensureDependencyExists(dependency);
        if (!this.relationships.containsKey(dependency.externalId)) {
            this.relationships.put(dependency.externalId, new HashSet());
        }
    }

    private void addRelationship(Dependency parent, Dependency child) {
        this.relationships.get(parent.externalId).add(child.externalId);
    }

    private Set<Dependency> dependenciesFromExternalIds(Set<ExternalId> ids) {
        HashSet<Dependency> foundDependencies = new HashSet<Dependency>();
        for (ExternalId id : ids) {
            if (!this.dependencies.containsKey(id)) continue;
            foundDependencies.add(this.dependencies.get(id));
        }
        return foundDependencies;
    }
}

