/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.synopsys.integration.hub.bdio.BdioNodeFactory;
import com.synopsys.integration.hub.bdio.BdioPropertyHelper;
import com.synopsys.integration.hub.bdio.BdioWriter;
import com.synopsys.integration.hub.bdio.graph.DependencyGraph;
import com.synopsys.integration.hub.bdio.graph.DependencyGraphTransformer;
import com.synopsys.integration.hub.bdio.graph.MutableDependencyGraph;
import com.synopsys.integration.hub.bdio.graph.MutableMapDependencyGraph;
import com.synopsys.integration.hub.bdio.model.BdioBillOfMaterials;
import com.synopsys.integration.hub.bdio.model.BdioComponent;
import com.synopsys.integration.hub.bdio.model.BdioExternalIdentifier;
import com.synopsys.integration.hub.bdio.model.BdioNode;
import com.synopsys.integration.hub.bdio.model.BdioProject;
import com.synopsys.integration.hub.bdio.model.Forge;
import com.synopsys.integration.hub.bdio.model.SimpleBdioDocument;
import com.synopsys.integration.hub.bdio.model.dependency.Dependency;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalIdFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;

public class SimpleBdioFactory {
    private final BdioPropertyHelper bdioPropertyHelper;
    private final BdioNodeFactory bdioNodeFactory;
    private final DependencyGraphTransformer dependencyGraphTransformer;
    private final ExternalIdFactory externalIdFactory;
    private final Gson gson;

    public SimpleBdioFactory() {
        this.bdioPropertyHelper = new BdioPropertyHelper();
        this.bdioNodeFactory = new BdioNodeFactory(this.bdioPropertyHelper);
        this.dependencyGraphTransformer = new DependencyGraphTransformer(this.bdioPropertyHelper, this.bdioNodeFactory);
        this.externalIdFactory = new ExternalIdFactory();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public SimpleBdioFactory(BdioPropertyHelper bdioPropertyHelper, BdioNodeFactory bdioNodeFactory, DependencyGraphTransformer dependencyGraphTransformer, ExternalIdFactory externalIdFactory, Gson gson) {
        this.bdioPropertyHelper = bdioPropertyHelper;
        this.bdioNodeFactory = bdioNodeFactory;
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        this.externalIdFactory = externalIdFactory;
        this.gson = gson;
    }

    public MutableDependencyGraph createMutableDependencyGraph() {
        return new MutableMapDependencyGraph();
    }

    public Dependency createDependency(String name, String version, ExternalId externalId) {
        return new Dependency(name, version, externalId);
    }

    public BdioWriter createBdioWriter(Writer writer) throws IOException {
        return new BdioWriter(this.gson, writer);
    }

    public BdioWriter createBdioWriter(OutputStream outputStream) throws IOException {
        return new BdioWriter(this.gson, outputStream);
    }

    public void writeSimpleBdioDocument(BdioWriter bdioWriter, SimpleBdioDocument simpleBdioDocument) {
        bdioWriter.writeSimpleBdioDocument(simpleBdioDocument);
    }

    public void writeSimpleBdioDocumentToFile(File bdioFile, SimpleBdioDocument simpleBdioDocument) throws IOException {
        try (BdioWriter bdioWriter = this.createBdioWriter(new FileOutputStream(bdioFile));){
            this.writeSimpleBdioDocument(bdioWriter, simpleBdioDocument);
        }
    }

    public SimpleBdioDocument createSimpleBdioDocument(String codeLocationName, String projectName, String projectVersionName, ExternalId projectExternalId) {
        BdioBillOfMaterials billOfMaterials = this.bdioNodeFactory.createBillOfMaterials(codeLocationName, projectName, projectVersionName);
        String projectId = projectExternalId.createBdioId();
        BdioExternalIdentifier projectExternalIdentifier = this.bdioPropertyHelper.createExternalIdentifier(projectExternalId);
        BdioProject project = this.bdioNodeFactory.createProject(projectName, projectVersionName, projectId, projectExternalIdentifier);
        SimpleBdioDocument simpleBdioDocument = new SimpleBdioDocument();
        simpleBdioDocument.billOfMaterials = billOfMaterials;
        simpleBdioDocument.project = project;
        return simpleBdioDocument;
    }

    public void populateComponents(SimpleBdioDocument simpleBdioDocument, ExternalId projectExternalId, DependencyGraph dependencyGraph) {
        HashMap<ExternalId, BdioNode> existingComponents = new HashMap<ExternalId, BdioNode>();
        existingComponents.put(projectExternalId, simpleBdioDocument.project);
        List<BdioComponent> bdioComponents = this.dependencyGraphTransformer.transformDependencyGraph(dependencyGraph, simpleBdioDocument.project, dependencyGraph.getRootDependencies(), existingComponents);
        simpleBdioDocument.components = bdioComponents;
    }

    public SimpleBdioDocument createSimpleBdioDocument(String projectName, String projectVersionName, ExternalId projectExternalId) {
        return this.createSimpleBdioDocument(null, projectName, projectVersionName, projectExternalId);
    }

    public SimpleBdioDocument createSimpleBdioDocument(String projectName, String projectVersionName, ExternalId projectExternalId, DependencyGraph dependencyGraph) {
        SimpleBdioDocument simpleBdioDocument = this.createSimpleBdioDocument(projectName, projectVersionName, projectExternalId);
        this.populateComponents(simpleBdioDocument, projectExternalId, dependencyGraph);
        return simpleBdioDocument;
    }

    public SimpleBdioDocument createSimpleBdioDocument(String codeLocationName, String projectName, String projectVersionName, ExternalId projectExternalId, DependencyGraph dependencyGraph) {
        SimpleBdioDocument simpleBdioDocument = this.createSimpleBdioDocument(codeLocationName, projectName, projectVersionName, projectExternalId);
        this.populateComponents(simpleBdioDocument, projectExternalId, dependencyGraph);
        return simpleBdioDocument;
    }

    public ExternalId createNameVersionExternalId(Forge forge, String name, String version) {
        return this.externalIdFactory.createNameVersionExternalId(forge, name, version);
    }

    public ExternalId createMavenExternalId(String group, String name, String version) {
        return this.externalIdFactory.createMavenExternalId(group, name, version);
    }

    public ExternalId createArchitectureExternalId(Forge forge, String name, String version, String architecture) {
        return this.externalIdFactory.createArchitectureExternalId(forge, name, version, architecture);
    }

    public ExternalId createModuleNamesExternalId(Forge forge, String ... moduleNames) {
        return this.externalIdFactory.createModuleNamesExternalId(forge, moduleNames);
    }

    public ExternalId createPathExternalId(Forge forge, String path) {
        return this.externalIdFactory.createPathExternalId(forge, path);
    }

    public BdioPropertyHelper getBdioPropertyHelper() {
        return this.bdioPropertyHelper;
    }

    public BdioNodeFactory getBdioNodeFactory() {
        return this.bdioNodeFactory;
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public ExternalIdFactory getExternalIdFactory() {
        return this.externalIdFactory;
    }
}

