/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner.command;

import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPaths;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.OperatingSystemType;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class ScanPathsUtility {
    public static final String STANDARD_OUT_FILENAME = "CLI_Output.txt";
    public static final String BDS_JAVA_HOME = "BDS_JAVA_HOME";
    private static final String JAVA_PATH_FORMAT = "bin" + File.separator + "%s";
    private static final String WINDOWS_JAVA_PATH = String.format(JAVA_PATH_FORMAT, "java.exe");
    private static final String OTHER_JAVA_PATH = String.format(JAVA_PATH_FORMAT, "java");
    private static final String STANDALONE_JAR_PATH = "cache" + File.separator + "scan.cli.impl-standalone.jar";
    private static final FileFilter EXCLUDE_NON_SCAN_CLI_DIRECTORIES_FILTER = file -> !file.isHidden() && !file.getName().contains("windows") && file.isDirectory();
    private static final FileFilter JRE_DIRECTORY_FILTER = file -> "jre".equalsIgnoreCase(file.getName()) && file.isDirectory();
    private static final FileFilter LIB_DIRECTORY_FILTER = file -> "lib".equalsIgnoreCase(file.getName()) && file.isDirectory();
    private static final FileFilter SCAN_CLI_JAR_FILE_FILTER = file -> file.getName().startsWith("scan.cli") && file.getName().endsWith(".jar") && file.isFile();
    private final AtomicInteger defaultMultiThreadingId = new AtomicInteger(0);
    private final IntLogger logger;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final OperatingSystemType operatingSystemType;

    public ScanPathsUtility(IntLogger logger, IntEnvironmentVariables intEnvironmentVariables, OperatingSystemType operatingSystemType) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.operatingSystemType = operatingSystemType;
    }

    public ScanPaths determineSignatureScannerPaths(File directory) throws HubIntegrationException {
        String pathToJavaExecutable;
        if (directory == null || !directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s is not a valid directory", directory.getAbsolutePath()));
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException(String.format("%s does not exist.", directory.getAbsolutePath()));
        }
        boolean managedByLibrary = false;
        File installDirectory = directory;
        File[] hubScanInstallationDirectories = directory.listFiles(file -> "Black_Duck_Scan_Installation".equals(file.getName()));
        if (hubScanInstallationDirectories.length == 1) {
            this.logger.debug("The directory structure was likely created by the installer");
            installDirectory = this.findFirstFilteredFile(hubScanInstallationDirectories[0], EXCLUDE_NON_SCAN_CLI_DIRECTORIES_FILTER, "No scan.cli directories could be found in %s.");
            managedByLibrary = true;
        } else {
            this.logger.debug(String.format("The directory structure was likely created manually - be sure the jre folder exists in: %s", installDirectory.getAbsolutePath()));
        }
        String bdsJavaHome = this.intEnvironmentVariables.getValue(BDS_JAVA_HOME);
        if (StringUtils.isNotBlank((CharSequence)bdsJavaHome)) {
            pathToJavaExecutable = bdsJavaHome;
        } else {
            File jreContentsDirectory = this.findFirstFilteredFile(installDirectory, JRE_DIRECTORY_FILTER, "Could not find the 'jre' directory in %s.");
            pathToJavaExecutable = this.findPathToJavaExe(jreContentsDirectory);
        }
        File libDirectory = this.findFirstFilteredFile(installDirectory, LIB_DIRECTORY_FILTER, "Could not find the 'lib' directory in %s.");
        String pathToOneJar = this.findPathToStandaloneJar(libDirectory);
        String pathToScanExecutable = this.findPathToScanCliJar(libDirectory);
        return new ScanPaths(pathToJavaExecutable, pathToOneJar, pathToScanExecutable, managedByLibrary);
    }

    public File createSpecificRunOutputDirectory(File generalOutputDirectory) throws IOException, HubIntegrationException {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss-SSS").withZone(ZoneOffset.UTC);
        String timeStringPrefix = Instant.now().atZone(ZoneOffset.UTC).format(dateTimeFormatter);
        int uniqueThreadIdSuffix = this.defaultMultiThreadingId.incrementAndGet();
        return this.createRunOutputDirectory(generalOutputDirectory, timeStringPrefix, Integer.toString(uniqueThreadIdSuffix));
    }

    public File createRunOutputDirectory(File generalOutputDirectory, String userProvidedPrefix, String userProvidedUniqueSuffix) throws IOException, HubIntegrationException {
        String signatureScanOutputDirectoryName = "BlackDuckScanOutput";
        File signatureScanOutputDirectory = new File(generalOutputDirectory, "BlackDuckScanOutput");
        String uniqueOutputDirectoryName = userProvidedPrefix + "_" + userProvidedUniqueSuffix;
        File specificRunOutputDirectory = new File(signatureScanOutputDirectory, uniqueOutputDirectoryName);
        if (!specificRunOutputDirectory.exists() && !specificRunOutputDirectory.mkdirs()) {
            throw new HubIntegrationException(String.format("Could not create the %s directory!", specificRunOutputDirectory.getAbsolutePath()));
        }
        File bdIgnoreLogsFile = new File(generalOutputDirectory, ".bdignore");
        if (!bdIgnoreLogsFile.exists()) {
            if (!bdIgnoreLogsFile.createNewFile()) {
                throw new HubIntegrationException(String.format("Could not create the %s file!", bdIgnoreLogsFile.getAbsolutePath()));
            }
            String exclusionPattern = "/BlackDuckScanOutput/";
            Files.write(bdIgnoreLogsFile.toPath(), "/BlackDuckScanOutput/".getBytes(), new OpenOption[0]);
        }
        return specificRunOutputDirectory;
    }

    public File createStandardOutFile(File specificRunOutputDirectory) throws IOException {
        File standardOutFile = new File(specificRunOutputDirectory, STANDARD_OUT_FILENAME);
        standardOutFile.createNewFile();
        return standardOutFile;
    }

    private String findPathToJavaExe(File jreContentsDirectory) throws HubIntegrationException {
        File jreContents = jreContentsDirectory;
        List<String> filenames = Arrays.asList(jreContents.list());
        if (filenames.contains("Contents")) {
            jreContents = new File(jreContents, "Contents");
            jreContents = new File(jreContents, "Home");
        }
        File javaExe = new File(jreContents, OTHER_JAVA_PATH);
        if (OperatingSystemType.WINDOWS == this.operatingSystemType) {
            javaExe = new File(jreContents, WINDOWS_JAVA_PATH);
        }
        if (!javaExe.exists() || !javaExe.isFile()) {
            throw new HubIntegrationException(String.format("The java executable does not exist at: %s", javaExe.getAbsolutePath()));
        }
        return javaExe.getAbsolutePath();
    }

    private String findPathToStandaloneJar(File libDirectory) throws HubIntegrationException {
        File standaloneJarFile = new File(libDirectory, STANDALONE_JAR_PATH);
        if (!standaloneJarFile.exists() || !standaloneJarFile.isFile()) {
            throw new HubIntegrationException(String.format("The standalone jar does not exist at: %s", standaloneJarFile.getAbsolutePath()));
        }
        return standaloneJarFile.getAbsolutePath();
    }

    private String findPathToScanCliJar(File libDirectory) throws HubIntegrationException {
        File scanCliJarFile = this.findFirstFilteredFile(libDirectory, SCAN_CLI_JAR_FILE_FILTER, "");
        if (!scanCliJarFile.exists() || !scanCliJarFile.isFile()) {
            throw new HubIntegrationException(String.format("The scan.cli jar does not exist at: %s", scanCliJarFile.getAbsolutePath()));
        }
        return scanCliJarFile.getAbsolutePath();
    }

    private File findFirstFilteredFile(File directory, FileFilter fileFilter, String notFoundMessageFormat) throws HubIntegrationException {
        File[] potentialItems = directory.listFiles(fileFilter);
        if (potentialItems == null || potentialItems.length < 1) {
            throw new HubIntegrationException(String.format(notFoundMessageFormat, directory.getAbsolutePath()));
        }
        return potentialItems[0];
    }
}

