/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.enumeration.ScanSummaryStatusType;
import com.synopsys.integration.blackduck.api.generated.enumeration.CodeLocationType;
import com.synopsys.integration.blackduck.api.generated.view.CodeLocationView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.view.ScanSummaryView;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.exception.HubTimeoutExceededException;
import com.synopsys.integration.blackduck.service.CodeLocationService;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.ProjectService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ScanStatusService
extends DataService {
    public static final long FIVE_SECONDS = 5000L;
    public static final long DEFAULT_TIMEOUT = 300000L;
    private static final Set<ScanSummaryStatusType> PENDING_STATES = EnumSet.of(ScanSummaryStatusType.UNSTARTED, new ScanSummaryStatusType[]{ScanSummaryStatusType.SCANNING, ScanSummaryStatusType.SAVING_SCAN_DATA, ScanSummaryStatusType.SCAN_DATA_SAVE_COMPLETE, ScanSummaryStatusType.REQUESTED_MATCH_JOB, ScanSummaryStatusType.MATCHING, ScanSummaryStatusType.BOM_VERSION_CHECK, ScanSummaryStatusType.BUILDING_BOM});
    private static final Set<ScanSummaryStatusType> DONE_STATES = EnumSet.of(ScanSummaryStatusType.COMPLETE, new ScanSummaryStatusType[]{ScanSummaryStatusType.CANCELLED, ScanSummaryStatusType.CLONED, ScanSummaryStatusType.ERROR_SCANNING, ScanSummaryStatusType.ERROR_SAVING_SCAN_DATA, ScanSummaryStatusType.ERROR_MATCHING, ScanSummaryStatusType.ERROR_BUILDING_BOM, ScanSummaryStatusType.ERROR});
    private static final Set<ScanSummaryStatusType> ERROR_STATES = EnumSet.of(ScanSummaryStatusType.CANCELLED, new ScanSummaryStatusType[]{ScanSummaryStatusType.ERROR_SCANNING, ScanSummaryStatusType.ERROR_SAVING_SCAN_DATA, ScanSummaryStatusType.ERROR_MATCHING, ScanSummaryStatusType.ERROR_BUILDING_BOM, ScanSummaryStatusType.ERROR});
    private final ProjectService projectDataService;
    private final CodeLocationService codeLocationDataService;
    private final long timeoutInMilliseconds;

    public ScanStatusService(HubService hubService, IntLogger logger, ProjectService projectDataService, CodeLocationService codeLocationDataService, long timeoutInMilliseconds) {
        super(hubService, logger);
        this.projectDataService = projectDataService;
        this.codeLocationDataService = codeLocationDataService;
        long timeout = timeoutInMilliseconds;
        if (timeoutInMilliseconds <= 0L) {
            timeout = 300000L;
            this.logger.alwaysLog(timeoutInMilliseconds + "ms is not a valid BOM wait time, using : " + timeout + "ms instead");
        }
        this.timeoutInMilliseconds = timeout;
    }

    public void assertBomImportScanStartedThenFinished(String projectName, String projectVersion) throws InterruptedException, HubTimeoutExceededException, IntegrationException {
        List<ScanSummaryView> pendingScans = this.waitForPendingScansToStart(projectName, projectVersion, this.timeoutInMilliseconds);
        this.waitForScansToComplete(pendingScans, this.timeoutInMilliseconds);
    }

    public void assertScansFinished(List<ScanSummaryView> pendingScans) throws InterruptedException, HubTimeoutExceededException, IntegrationException {
        this.waitForScansToComplete(pendingScans, this.timeoutInMilliseconds);
    }

    public void assertScansFinished(String projectName, String projectVersion) throws InterruptedException, IntegrationException {
        ProjectView projectItem = this.projectDataService.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.projectDataService.getProjectVersion(projectItem, projectVersion);
        this.assertScansFinished(projectVersionView);
    }

    public void assertScansFinished(ProjectVersionView projectVersionView) throws InterruptedException, HubTimeoutExceededException, IntegrationException {
        List<CodeLocationView> allCodeLocations = this.hubService.getAllResponses(projectVersionView, ProjectVersionView.CODELOCATIONS_LINK_RESPONSE);
        ArrayList<ScanSummaryView> scanSummaryViews = new ArrayList<ScanSummaryView>();
        for (CodeLocationView codeLocationView : allCodeLocations) {
            String scansLink = this.hubService.getFirstLinkSafely(codeLocationView, "scans");
            List<ScanSummaryView> codeLocationScanSummaryViews = this.hubService.getAllResponses(scansLink, ScanSummaryView.class);
            scanSummaryViews.addAll(codeLocationScanSummaryViews);
        }
        this.assertScansFinished(scanSummaryViews);
    }

    private List<ScanSummaryView> waitForPendingScansToStart(String projectName, String projectVersion, long scanStartedTimeoutInMilliseconds) throws InterruptedException, HubIntegrationException {
        List<ScanSummaryView> pendingScans = this.getPendingScans(projectName, projectVersion);
        long startedTime = System.currentTimeMillis();
        boolean pendingScansOk = pendingScans.size() > 0;
        String timeoutMessage = "No scan has started within the specified wait time: %d minutes";
        while (!this.done(pendingScansOk, scanStartedTimeoutInMilliseconds, startedTime, "No scan has started within the specified wait time: %d minutes")) {
            this.sleep("The thread waiting for the scan to start was interrupted: ", "Still waiting for the pending scans to start.");
            pendingScans = this.getPendingScans(projectName, projectVersion);
            pendingScansOk = pendingScans.size() > 0;
        }
        return pendingScans;
    }

    private void waitForScansToComplete(List<ScanSummaryView> pendingScans, long scanStartedTimeoutInMilliseconds) throws InterruptedException, HubTimeoutExceededException, IntegrationException {
        pendingScans = this.getPendingScans(pendingScans);
        long startedTime = System.currentTimeMillis();
        boolean pendingScansOk = pendingScans.isEmpty();
        String timeoutMessage = "The pending scans have not completed within the specified wait time: %d minutes";
        while (!this.done(pendingScansOk, scanStartedTimeoutInMilliseconds, startedTime, "The pending scans have not completed within the specified wait time: %d minutes")) {
            this.sleep("The thread waiting for the scan to complete was interrupted: ", "Still waiting for the pending scans to complete.");
            pendingScans = this.getPendingScans(pendingScans);
            pendingScansOk = pendingScans.isEmpty();
        }
    }

    private void sleep(String interruptedMessage, String ongoingMessage) throws InterruptedException {
        this.logger.info(ongoingMessage);
        Thread.sleep(5000L);
    }

    private boolean done(boolean conditionToCheck, long timeoutInMilliseconds, long startedTime, String timeoutMessage) throws HubTimeoutExceededException {
        if (conditionToCheck) {
            return true;
        }
        if (this.takenTooLong(timeoutInMilliseconds, startedTime)) {
            throw new HubTimeoutExceededException(String.format(timeoutMessage, TimeUnit.MILLISECONDS.toMinutes(timeoutInMilliseconds)));
        }
        return false;
    }

    private boolean takenTooLong(long timeoutInMilliseconds, long startedTime) {
        long elapsed = System.currentTimeMillis() - startedTime;
        return elapsed > timeoutInMilliseconds;
    }

    private List<ScanSummaryView> getPendingScans(String projectName, String projectVersion) {
        ArrayList<ScanSummaryView> pendingScans = new ArrayList<ScanSummaryView>();
        try {
            ProjectView projectItem = this.projectDataService.getProjectByName(projectName);
            ProjectVersionView projectVersionItem = this.projectDataService.getProjectVersion(projectItem, projectVersion);
            String projectVersionUrl = this.hubService.getHref(projectVersionItem);
            List<CodeLocationView> allCodeLocations = this.codeLocationDataService.getAllCodeLocationsForCodeLocationType(CodeLocationType.BOM_IMPORT);
            ArrayList<String> allScanSummariesLinks = new ArrayList<String>();
            for (CodeLocationView codeLocationItem : allCodeLocations) {
                this.logger.debug("Checking codeLocation: " + codeLocationItem.name);
                String mappedProjectVersionUrl = codeLocationItem.mappedProjectVersion;
                if (!projectVersionUrl.equals(mappedProjectVersionUrl)) continue;
                String scanSummariesLink = this.hubService.getFirstLink(codeLocationItem, "scans");
                allScanSummariesLinks.add(scanSummariesLink);
            }
            ArrayList<ScanSummaryView> allScanSummaries = new ArrayList<ScanSummaryView>();
            for (String scanSummaryLink : allScanSummariesLinks) {
                allScanSummaries.addAll(this.hubService.getAllResponses(scanSummaryLink, ScanSummaryView.class));
            }
            pendingScans = new ArrayList();
            for (ScanSummaryView scanSummaryItem : allScanSummaries) {
                if (!this.isPending(scanSummaryItem.status)) continue;
                this.logger.debug("Adding pending scan: " + scanSummaryItem.json);
                pendingScans.add(scanSummaryItem);
            }
        }
        catch (Exception e) {
            pendingScans = new ArrayList();
            this.logger.debug("Not able to get pending scans: " + e.getMessage());
        }
        return pendingScans;
    }

    private List<ScanSummaryView> getPendingScans(List<ScanSummaryView> scanSummaries) throws IntegrationException {
        ArrayList<ScanSummaryView> pendingScans = new ArrayList<ScanSummaryView>();
        for (ScanSummaryView scanSummaryItem : scanSummaries) {
            String scanSummaryLink = this.hubService.getHref(scanSummaryItem);
            ScanSummaryView currentScanSummaryItem = this.hubService.getResponse(scanSummaryLink, ScanSummaryView.class);
            if (this.isPending(currentScanSummaryItem.status)) {
                pendingScans.add(currentScanSummaryItem);
                continue;
            }
            if (!this.isError(currentScanSummaryItem.status)) continue;
            throw new HubIntegrationException("There was a problem in the Hub processing the scan(s). Error Status : " + currentScanSummaryItem.status.toString() + ", " + currentScanSummaryItem.statusMessage);
        }
        return pendingScans;
    }

    public boolean isPending(ScanSummaryStatusType statusEnum) {
        return PENDING_STATES.contains((Object)statusEnum);
    }

    public boolean isDone(ScanSummaryStatusType statusEnum) {
        return DONE_STATES.contains((Object)statusEnum);
    }

    public boolean isError(ScanSummaryStatusType statusEnum) {
        return ERROR_STATES.contains((Object)statusEnum);
    }
}

