/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.synopsys.integration.blackduck.api.UriSingleResponse;
import com.synopsys.integration.blackduck.api.core.HubPath;
import com.synopsys.integration.blackduck.api.core.HubPathMultipleResponses;
import com.synopsys.integration.blackduck.api.core.HubPathSingleResponse;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.api.core.HubView;
import com.synopsys.integration.blackduck.api.core.LinkMultipleResponses;
import com.synopsys.integration.blackduck.api.core.LinkSingleResponse;
import com.synopsys.integration.blackduck.api.core.ResourceLink;
import com.synopsys.integration.blackduck.api.core.ResourceMetadata;
import com.synopsys.integration.blackduck.api.view.MetaHandler;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.blackduck.service.HubResponseTransformer;
import com.synopsys.integration.blackduck.service.HubResponsesTransformer;
import com.synopsys.integration.blackduck.service.model.PagedRequest;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HubService {
    public static final HubPath BOMIMPORT_PATH = new HubPath("/api/bom-import");
    public static final HubPath SCANSUMMARIES_PATH = new HubPath("/api/scan-summaries");
    private final BlackduckRestConnection restConnection;
    private final MetaHandler metaHandler;
    private final HubResponseTransformer hubResponseTransformer;
    private final HubResponsesTransformer hubResponsesTransformer;
    private final URL hubBaseUrl;
    private final JsonParser jsonParser;
    private final Gson gson;

    public HubService(IntLogger logger, BlackduckRestConnection restConnection, Gson gson, JsonParser jsonParser) {
        this.restConnection = restConnection;
        this.hubBaseUrl = restConnection.getBaseUrl();
        this.jsonParser = jsonParser;
        this.gson = gson;
        this.metaHandler = new MetaHandler(logger);
        this.hubResponseTransformer = new HubResponseTransformer(restConnection, gson, jsonParser);
        this.hubResponsesTransformer = new HubResponsesTransformer(restConnection, this.hubResponseTransformer, jsonParser);
    }

    public BlackduckRestConnection getRestConnection() {
        return this.restConnection;
    }

    public URL getHubBaseUrl() {
        return this.hubBaseUrl;
    }

    public JsonParser getJsonParser() {
        return this.jsonParser;
    }

    public Gson getGson() {
        return this.gson;
    }

    public String convertToJson(Object obj) {
        return this.gson.toJson(obj);
    }

    public boolean hasLink(HubView view, String linkKey) throws HubIntegrationException {
        return this.metaHandler.hasLink(view, linkKey);
    }

    public String getFirstLink(HubView view, String linkKey) throws HubIntegrationException {
        return this.metaHandler.getFirstLink(view, linkKey);
    }

    public String getFirstLinkSafely(HubView view, String linkKey) {
        return this.metaHandler.getFirstLinkSafely(view, linkKey);
    }

    public List<String> getLinks(HubView view, String linkKey) throws HubIntegrationException {
        return this.metaHandler.getLinks(view, linkKey);
    }

    public ResourceMetadata getMetaView(HubView view) throws HubIntegrationException {
        return this.metaHandler.getMetaView(view);
    }

    public List<ResourceLink> getLinkViews(HubView view) throws HubIntegrationException {
        return this.metaHandler.getLinkViews(view);
    }

    public List<String> getAllowedMethods(HubView view) throws HubIntegrationException {
        return this.metaHandler.getAllowedMethods(view);
    }

    public String getHref(HubView view) throws HubIntegrationException {
        return this.metaHandler.getHref(view);
    }

    public String getUri(HubPath path) throws IntegrationException {
        return this.pieceTogetherUri(this.hubBaseUrl, path.getPath());
    }

    public <T extends HubResponse> List<T> getAllResponses(HubPathMultipleResponses<T> hubPathMultipleResponses) throws IntegrationException {
        return this.getResponses(hubPathMultipleResponses, true);
    }

    public <T extends HubResponse> List<T> getAllResponses(HubPathMultipleResponses<T> hubPathMultipleResponses, Request.Builder requestBuilder) throws IntegrationException {
        return this.getResponses(hubPathMultipleResponses, requestBuilder, true);
    }

    public <T extends HubResponse> List<T> getResponses(HubPathMultipleResponses<T> hubPathMultipleResponses, boolean getAll) throws IntegrationException {
        String uri = this.pieceTogetherUri(this.hubBaseUrl, hubPathMultipleResponses.hubPath.getPath());
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(uri);
        return this.hubResponsesTransformer.getResponses(new PagedRequest(requestBuilder), hubPathMultipleResponses.responseClass, getAll, null);
    }

    public <T extends HubResponse> List<T> getResponses(HubPathMultipleResponses<T> hubPathMultipleResponses, Request.Builder requestBuilder, boolean getAll) throws IntegrationException {
        return this.getResponses(hubPathMultipleResponses, requestBuilder, getAll, null);
    }

    public <T extends HubResponse> List<T> getResponses(HubPathMultipleResponses<T> hubPathMultipleResponses, Request.Builder requestBuilder, boolean getAll, Map<String, Class<? extends T>> typeMap) throws IntegrationException {
        String uri = this.pieceTogetherUri(this.hubBaseUrl, hubPathMultipleResponses.hubPath.getPath());
        requestBuilder.uri(uri);
        return this.hubResponsesTransformer.getResponses(new PagedRequest(requestBuilder), hubPathMultipleResponses.responseClass, getAll, typeMap);
    }

    public <T extends HubResponse> T getResponse(HubPathSingleResponse<T> hubPathSingleResponse) throws IntegrationException {
        String uri = this.pieceTogetherUri(this.hubBaseUrl, hubPathSingleResponse.hubPath.getPath());
        Request request = RequestFactory.createCommonGetRequest(uri);
        return this.hubResponseTransformer.getResponse(request, hubPathSingleResponse.responseClass);
    }

    public <T extends HubResponse> List<T> getAllResponses(HubView hubView, LinkMultipleResponses<T> linkMultipleResponses) throws IntegrationException {
        return this.getResponses(hubView, linkMultipleResponses, true);
    }

    public <T extends HubResponse> List<T> getAllResponses(HubView hubView, LinkMultipleResponses<T> linkMultipleResponses, Request.Builder requestBuilder) throws IntegrationException {
        return this.getResponses(hubView, linkMultipleResponses, requestBuilder, true);
    }

    public <T extends HubResponse> List<T> getResponses(HubView hubView, LinkMultipleResponses<T> linkMultipleResponses, boolean getAll) throws IntegrationException {
        String uri = this.metaHandler.getFirstLinkSafely(hubView, linkMultipleResponses.link);
        if (StringUtils.isBlank((CharSequence)uri)) {
            return Collections.emptyList();
        }
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(uri);
        return this.hubResponsesTransformer.getResponses(new PagedRequest(requestBuilder), linkMultipleResponses.responseClass, getAll, null);
    }

    public <T extends HubResponse> List<T> getResponses(HubView hubView, LinkMultipleResponses<T> linkMultipleResponses, Request.Builder requestBuilder, boolean getAll) throws IntegrationException {
        String uri = this.metaHandler.getFirstLinkSafely(hubView, linkMultipleResponses.link);
        if (StringUtils.isBlank((CharSequence)uri)) {
            return Collections.emptyList();
        }
        requestBuilder.uri(uri);
        return this.hubResponsesTransformer.getResponses(new PagedRequest(requestBuilder), linkMultipleResponses.responseClass, getAll, null);
    }

    public <T extends HubResponse> List<T> getResponses(HubView hubView, LinkMultipleResponses<T> linkMultipleResponses, Request.Builder requestBuilder, boolean getAll, Map<String, Class<? extends T>> typeMap) throws IntegrationException {
        String uri = this.metaHandler.getFirstLinkSafely(hubView, linkMultipleResponses.link);
        if (StringUtils.isBlank((CharSequence)uri)) {
            return Collections.emptyList();
        }
        requestBuilder.uri(uri);
        return this.hubResponsesTransformer.getResponses(new PagedRequest(requestBuilder), linkMultipleResponses.responseClass, getAll, typeMap);
    }

    public <T extends HubResponse> T getResponse(HubView hubView, LinkSingleResponse<T> linkSingleResponse) throws IntegrationException {
        String uri = this.metaHandler.getFirstLinkSafely(hubView, linkSingleResponse.link);
        if (StringUtils.isBlank((CharSequence)uri)) {
            return null;
        }
        Request request = RequestFactory.createCommonGetRequest(uri);
        return this.hubResponseTransformer.getResponse(request, linkSingleResponse.responseClass);
    }

    public <T extends HubResponse> List<T> getAllResponses(String uri, Class<T> responseClass) throws IntegrationException {
        return this.getResponses(uri, responseClass, true);
    }

    public <T extends HubResponse> List<T> getResponses(String uri, Class<T> responseClass, boolean getAll) throws IntegrationException {
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(uri);
        return this.getResponses(requestBuilder, responseClass, getAll);
    }

    public <T extends HubResponse> List<T> getResponses(Request.Builder requestBuilder, Class<T> responseClass, boolean getAll) throws IntegrationException {
        return this.hubResponsesTransformer.getResponses(new PagedRequest(requestBuilder), responseClass, getAll, null);
    }

    public <T extends HubResponse> T getResponse(String uri, Class<T> responseClass) throws IntegrationException {
        Request request = RequestFactory.createCommonGetRequest(uri);
        return this.hubResponseTransformer.getResponse(request, responseClass);
    }

    public <T extends HubResponse> T getResponse(UriSingleResponse<T> uriSingleResponse) throws IntegrationException {
        Request request = RequestFactory.createCommonGetRequest(uriSingleResponse.uri);
        return this.hubResponseTransformer.getResponse(request, uriSingleResponse.responseClass);
    }

    public Response executeGetRequest(String uri) throws IntegrationException {
        return this.restConnection.executeRequest(RequestFactory.createCommonGetRequest(uri));
    }

    public Response executeGetRequest(HubPath path) throws IntegrationException {
        String uri = this.pieceTogetherUri(this.restConnection.getBaseUrl(), path.getPath());
        return this.restConnection.executeRequest(RequestFactory.createCommonGetRequest(uri));
    }

    public Response executeRequest(HubPath path, Request.Builder requestBuilder) throws IntegrationException {
        String uri = this.pieceTogetherUri(this.restConnection.getBaseUrl(), path.getPath());
        requestBuilder.uri(uri);
        return this.executeRequest(requestBuilder.build());
    }

    public Response executeRequest(Request request) throws IntegrationException {
        return this.restConnection.executeRequest(request);
    }

    public String executePostRequestAndRetrieveURL(HubPath path, Request.Builder requestBuilder) throws IntegrationException {
        String uri = this.pieceTogetherUri(this.restConnection.getBaseUrl(), path.getPath());
        requestBuilder.uri(uri);
        return this.executePostRequestAndRetrieveURL(requestBuilder.build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executePostRequestAndRetrieveURL(Request request) throws IntegrationException {
        try (Response response = this.executeRequest(request);){
            String string = response.getHeaderValue("location");
            return string;
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    private String pieceTogetherUri(URL baseURL, String spec) throws HubIntegrationException {
        URL url;
        try {
            url = new URL(baseURL, spec);
        }
        catch (MalformedURLException e) {
            throw new HubIntegrationException(String.format("Could not construct the URL from %s and %s", baseURL.toString(), spec), e);
        }
        return url.toString();
    }
}

