/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.core.HubPath;
import com.synopsys.integration.blackduck.api.core.HubPathSingleResponse;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.enumeration.CodeLocationType;
import com.synopsys.integration.blackduck.api.generated.view.CodeLocationView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.view.ScanSummaryView;
import com.synopsys.integration.blackduck.exception.DoesNotExistException;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.model.HubQuery;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.body.StringBodyContent;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class CodeLocationService
extends DataService {
    public CodeLocationService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
    }

    public void importBomFile(File file) throws IntegrationException {
        this.importBomFile(file, "application/ld+json");
    }

    public void importBomFile(File file, String mimeType) throws IntegrationException {
        String jsonPayload;
        try {
            jsonPayload = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IntegrationException("Failed to import Bom file: " + file.getAbsolutePath() + " to the Hub because : " + e.getMessage(), e);
        }
        String uri = this.hubService.getUri(HubService.BOMIMPORT_PATH);
        Request request = RequestFactory.createCommonPostRequestBuilder(jsonPayload).uri(uri).mimeType(mimeType).build();
        try {
            Response response = this.hubService.executeRequest(request);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public List<CodeLocationView> getAllCodeLocationsForCodeLocationType(CodeLocationType codeLocationType) throws IntegrationException {
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder().addQueryParameter("codeLocationType", codeLocationType.toString());
        List<CodeLocationView> allCodeLocations = this.hubService.getAllResponses(ApiDiscovery.CODELOCATIONS_LINK_RESPONSE, requestBuilder);
        return allCodeLocations;
    }

    public void unmapCodeLocations(List<CodeLocationView> codeLocationViews) throws IntegrationException {
        for (CodeLocationView codeLocationView : codeLocationViews) {
            this.unmapCodeLocation(codeLocationView);
        }
    }

    public void unmapCodeLocation(CodeLocationView codeLocationView) throws IntegrationException {
        String codeLocationViewUrl = this.hubService.getHref(codeLocationView);
        CodeLocationView requestCodeLocationView = this.createRequestCodeLocationView(codeLocationView, "");
        this.updateCodeLocation(codeLocationViewUrl, this.hubService.getGson().toJson(requestCodeLocationView));
    }

    public void mapCodeLocation(CodeLocationView codeLocationView, ProjectVersionView version) throws IntegrationException {
        this.mapCodeLocation(codeLocationView, this.hubService.getHref(version));
    }

    public void mapCodeLocation(CodeLocationView codeLocationView, String versionUrl) throws IntegrationException {
        String codeLocationViewUrl = this.hubService.getHref(codeLocationView);
        CodeLocationView requestCodeLocationView = this.createRequestCodeLocationView(codeLocationView, versionUrl);
        this.updateCodeLocation(codeLocationViewUrl, this.hubService.getGson().toJson(requestCodeLocationView));
    }

    public void updateCodeLocation(CodeLocationView codeLocationView) throws IntegrationException {
        String codeLocationViewUrl = this.hubService.getHref(codeLocationView);
        this.updateCodeLocation(codeLocationViewUrl, this.hubService.getGson().toJson(codeLocationView));
    }

    public void updateCodeLocation(String codeLocationViewUrl, String codeLocationViewJson) throws IntegrationException {
        Request request = new Request.Builder(codeLocationViewUrl).method(HttpMethod.PUT).bodyContent(new StringBodyContent(codeLocationViewJson)).build();
        try {
            Response response = this.hubService.executeRequest(request);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public void deleteCodeLocations(List<CodeLocationView> codeLocationViews) throws IntegrationException {
        for (CodeLocationView codeLocationView : codeLocationViews) {
            this.deleteCodeLocation(codeLocationView);
        }
    }

    public void deleteCodeLocation(CodeLocationView codeLocationView) throws IntegrationException {
        String codeLocationViewUrl = this.hubService.getHref(codeLocationView);
        this.deleteCodeLocation(codeLocationViewUrl);
    }

    public void deleteCodeLocation(String codeLocationViewUrl) throws IntegrationException {
        Request deleteRequest = new Request.Builder(codeLocationViewUrl).method(HttpMethod.DELETE).build();
        try {
            Response response = this.hubService.executeRequest(deleteRequest);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public CodeLocationView getCodeLocationByName(String codeLocationName) throws IntegrationException {
        if (StringUtils.isNotBlank((CharSequence)codeLocationName)) {
            Optional<HubQuery> hubQuery = HubQuery.createQuery("name", codeLocationName);
            Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(hubQuery);
            List<CodeLocationView> codeLocations = this.hubService.getAllResponses(ApiDiscovery.CODELOCATIONS_LINK_RESPONSE, requestBuilder);
            for (CodeLocationView codeLocation : codeLocations) {
                if (!codeLocationName.equals(codeLocation.name)) continue;
                return codeLocation;
            }
        }
        throw new DoesNotExistException("This Code Location does not exist. Code Location: " + codeLocationName);
    }

    public CodeLocationView getCodeLocationById(String codeLocationId) throws IntegrationException {
        HubPath hubPath = new HubPath(ApiDiscovery.CODELOCATIONS_LINK.getPath() + "/" + codeLocationId);
        HubPathSingleResponse<CodeLocationView> codeLocationResponse = new HubPathSingleResponse<CodeLocationView>(hubPath, CodeLocationView.class);
        return this.hubService.getResponse(codeLocationResponse);
    }

    private CodeLocationView createRequestCodeLocationView(CodeLocationView codeLocationView, String versionUrl) {
        CodeLocationView requestCodeLocationView = new CodeLocationView();
        requestCodeLocationView.createdAt = codeLocationView.createdAt;
        requestCodeLocationView.mappedProjectVersion = versionUrl;
        requestCodeLocationView.name = codeLocationView.name;
        requestCodeLocationView.type = codeLocationView.type;
        requestCodeLocationView.updatedAt = codeLocationView.updatedAt;
        requestCodeLocationView.url = codeLocationView.url;
        return requestCodeLocationView;
    }

    public ScanSummaryView getScanSummaryViewById(String scanSummaryId) throws IntegrationException {
        String uri = HubService.SCANSUMMARIES_PATH.getPath() + "/" + scanSummaryId;
        return this.hubService.getResponse(uri, ScanSummaryView.class);
    }
}

