/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.configuration;

import com.synopsys.integration.blackduck.ApiTokenField;
import com.synopsys.integration.blackduck.configuration.HubServerConfigFieldEnum;
import com.synopsys.integration.blackduck.service.model.HubServerVerifier;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.credentials.CredentialsBuilder;
import com.synopsys.integration.rest.credentials.CredentialsValidator;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.proxy.ProxyInfoField;
import com.synopsys.integration.rest.proxy.ProxyInfoValidator;
import com.synopsys.integration.validator.AbstractValidator;
import com.synopsys.integration.validator.ValidationResult;
import com.synopsys.integration.validator.ValidationResultEnum;
import com.synopsys.integration.validator.ValidationResults;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class HubServerConfigValidator
extends AbstractValidator {
    public static final String ERROR_MSG_URL_NOT_FOUND = "No Hub Url was found.";
    public static final String ERROR_MSG_URL_NOT_VALID_PREFIX = "This is not a valid URL: ";
    public static final String ERROR_MSG_UNREACHABLE_PREFIX = "Can not reach this server: ";
    public static final String ERROR_MSG_UNREACHABLE_CAUSE = ", because: ";
    public static final String ERROR_MSG_URL_NOT_VALID = "The Hub Url is not a valid URL.";
    public static final String ERROR_MSG_URL_NOT_HUB_PREFIX = "The Url does not appear to be a Hub server: ";
    public static int DEFAULT_TIMEOUT_SECONDS = 120;
    private final HubServerVerifier hubServerVerifier;
    private String hubUrl;
    private String timeoutSeconds;
    private String username;
    private String password;
    private int passwordLength;
    private String apiToken;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private int proxyPasswordLength;
    private String ignoredProxyHosts;
    private String proxyNtlmDomain;
    private String proxyNtlmWorkstation;
    private boolean alwaysTrustServerCertificate;
    private ProxyInfo proxyInfo;

    public HubServerConfigValidator() {
        this.hubServerVerifier = new HubServerVerifier();
    }

    public HubServerConfigValidator(HubServerVerifier hubServerVerifier) {
        this.hubServerVerifier = hubServerVerifier;
    }

    @Override
    public ValidationResults assertValid() {
        ValidationResults proxyResult = this.assertProxyValid();
        ValidationResults credentialsOrApiTokenResult = this.assertCredentialsOrApiTokenValid();
        ValidationResults result = new ValidationResults();
        result.addAllResults(proxyResult.getResultMap());
        result.addAllResults(credentialsOrApiTokenResult.getResultMap());
        this.validateHubUrl(result);
        this.validateTimeout(result, null);
        return result;
    }

    public ValidationResults assertProxyValid() {
        ValidationResults results;
        ProxyInfoValidator validator = new ProxyInfoValidator();
        validator.setHost(this.proxyHost);
        validator.setPort(this.proxyPort);
        validator.setIgnoredProxyHosts(this.ignoredProxyHosts);
        validator.setUsername(this.proxyUsername);
        validator.setPassword(this.proxyPassword);
        validator.setNtlmDomain(this.proxyNtlmDomain);
        validator.setNtlmWorkstation(this.proxyNtlmWorkstation);
        if (this.proxyPasswordLength > 0) {
            validator.setPasswordLength(this.proxyPasswordLength);
        }
        if ((results = validator.assertValid()).isSuccess() && validator.hasProxySettings()) {
            int port = NumberUtils.toInt((String)this.proxyPort);
            if (validator.hasAuthenticatedProxySettings()) {
                CredentialsBuilder credBuilder = new CredentialsBuilder();
                credBuilder.setUsername(this.proxyUsername);
                credBuilder.setPassword(this.proxyPassword);
                credBuilder.setPasswordLength(this.proxyPasswordLength);
                Credentials credResult = (Credentials)credBuilder.build();
                this.proxyInfo = new ProxyInfo(this.proxyHost, port, credResult, this.ignoredProxyHosts, this.proxyNtlmDomain, this.proxyNtlmWorkstation);
            } else {
                this.proxyInfo = new ProxyInfo(this.proxyHost, port, null, this.ignoredProxyHosts, this.proxyNtlmDomain, this.proxyNtlmWorkstation);
            }
        }
        return results;
    }

    public ValidationResults assertCredentialsOrApiTokenValid() {
        ValidationResults validationResults = new ValidationResults();
        if (StringUtils.isBlank((CharSequence)this.apiToken)) {
            CredentialsValidator credentialsBuilder = new CredentialsValidator();
            credentialsBuilder.setUsername(this.username);
            credentialsBuilder.setPassword(this.password);
            ValidationResults credentialsResults = credentialsBuilder.assertValid();
            validationResults.addAllResults(credentialsResults.getResultMap());
            if (validationResults.hasErrors()) {
                validationResults.addResult(ApiTokenField.API_TOKEN, new ValidationResult(ValidationResultEnum.ERROR, "No api token was found."));
            }
        }
        return validationResults;
    }

    public void validateHubUrl(ValidationResults result) {
        if (this.hubUrl == null) {
            result.addResult(HubServerConfigFieldEnum.HUBURL, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_URL_NOT_FOUND));
            return;
        }
        URL hubURL = null;
        try {
            hubURL = new URL(this.hubUrl);
            hubURL.toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            result.addResult(HubServerConfigFieldEnum.HUBURL, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_URL_NOT_VALID));
            return;
        }
        try {
            this.hubServerVerifier.verifyIsHubServer(hubURL, this.proxyInfo, this.alwaysTrustServerCertificate, NumberUtils.toInt((String)this.timeoutSeconds, (int)120));
        }
        catch (IntegrationRestException e) {
            if (e.getHttpStatusCode() == 407) {
                result.addResult(ProxyInfoField.PROXYUSERNAME, new ValidationResult(ValidationResultEnum.ERROR, e.getHttpStatusMessage()));
            } else {
                result.addResult(HubServerConfigFieldEnum.HUBURL, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_UNREACHABLE_PREFIX + this.hubUrl + ERROR_MSG_UNREACHABLE_CAUSE + e.getHttpStatusCode() + " : " + e.getHttpStatusMessage(), e));
            }
        }
        catch (IntegrationException e) {
            result.addResult(HubServerConfigFieldEnum.HUBURL, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_UNREACHABLE_PREFIX + this.hubUrl + ERROR_MSG_UNREACHABLE_CAUSE + e.getMessage(), e));
        }
    }

    public void validateTimeout(ValidationResults result) {
        this.validateTimeout(result, null);
    }

    private void validateTimeout(ValidationResults result, Integer defaultTimeoutSeconds) {
        if (StringUtils.isBlank((CharSequence)this.timeoutSeconds)) {
            result.addResult(HubServerConfigFieldEnum.HUBTIMEOUT, new ValidationResult(ValidationResultEnum.ERROR, "No Hub Timeout was found."));
            return;
        }
        int timeoutToValidate = 0;
        try {
            timeoutToValidate = this.stringToInteger(this.timeoutSeconds);
        }
        catch (IllegalArgumentException e) {
            result.addResult(HubServerConfigFieldEnum.HUBTIMEOUT, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            return;
        }
        if (timeoutToValidate <= 0) {
            result.addResult(HubServerConfigFieldEnum.HUBTIMEOUT, new ValidationResult(ValidationResultEnum.ERROR, "The Timeout must be greater than 0."));
        }
    }

    public void setTimeout(String timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public String getTimeout() {
        return this.timeoutSeconds;
    }

    public void setTimeout(int timeoutSeconds) {
        this.setTimeout(String.valueOf(timeoutSeconds));
    }

    public String getHubUrl() {
        return this.hubUrl;
    }

    public void setHubUrl(String hubUrl) {
        this.hubUrl = StringUtils.trimToNull((String)hubUrl);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.setProxyPort(String.valueOf(proxyPort));
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getProxyPasswordLength() {
        return this.proxyPasswordLength;
    }

    public void setProxyPasswordLength(int proxyPasswordLength) {
        this.proxyPasswordLength = proxyPasswordLength;
    }

    public String getProxyNtlmDomain() {
        return this.proxyNtlmDomain;
    }

    public void setProxyNtlmDomain(String ntlmDomain) {
        this.proxyNtlmDomain = ntlmDomain;
    }

    public String getProxyNtlmWorkstation() {
        return this.proxyNtlmWorkstation;
    }

    public void setProxyNtlmWorkstation(String ntlmWorkstation) {
        this.proxyNtlmWorkstation = ntlmWorkstation;
    }

    public String getIgnoredProxyHosts() {
        return this.ignoredProxyHosts;
    }

    public void setIgnoredProxyHosts(String ignoredProxyHosts) {
        this.ignoredProxyHosts = ignoredProxyHosts;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public void setAlwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }
}

