#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import yaml
import json
from blackduck.task.helper.risk_profile import *
from blackduck.hub_services_helper import HubServicesHelper
from blackduck.task import add_comment

global taskReportingApi, task

if not blackduckServer:
    raise Exception("Blackduck server ID must be provided")

def add_code_compliance_record(outcome=None, compliance_data=None, analysis_date=None, project_url=None):
    try:
        record = taskReportingApi.newCodeComplianceRecord()
        record.targetId = task.id
        record.serverUrl = blackduckServer['url']
        record.serverUser = blackduckServer['username']

        record.project = projectName
        record.outcome = outcome
        record.complianceData = yaml.dump(compliance_data, default_flow_style=False)
        record.analysisDate = analysis_date
        record.project_url = project_url

        taskReportingApi.addRecord(record, True)
    except:
        exctype, value = sys.exc_info()[:2]
        print("{} occurred while creating `udm.CodeComplianceRecord` - {}".format(exctype, value))

hub_services_helper = HubServicesHelper(params=blackduckServer)
hub_services_factory = hub_services_helper.get_hub_services_factory()
risk_profile_view, _, version_view = hub_services_helper.get_risk_profile(projectName, versionName)
policy_status = hub_services_helper.get_policy_status(projectName, versionName)

HIGH = "HIGH"
MEDIUM = "MEDIUM"
LOW = "LOW"
OK = "OK"

vulnerability = risk_profile_view.categories.get("VULNERABILITY")
security_risk_profile = RiskProfile('Security Risk',
                                    Risk(vulnerability.get(HIGH), securityRiskHighThreshold),
                                    Risk(vulnerability.get(MEDIUM), securityRiskMediumThreshold),
                                    Risk(vulnerability.get(LOW), securityRiskLowThreshold),
                                    Risk(vulnerability.get(OK), None))

license = risk_profile_view.categories.get("LICENSE")
license_risk_profile = RiskProfile('License Risk',
                                   Risk(license.get(HIGH), licenseRiskHighThreshold),
                                   Risk(license.get(MEDIUM), licenseRiskMediumThreshold),
                                   Risk(license.get(LOW), licenseRiskLowThreshold),
                                   Risk(license.get(OK), None))

operational = risk_profile_view.categories.get("OPERATIONAL")
operational_risk_profile = RiskProfile('Operational Risk',
                                       Risk(operational.get(HIGH), operationalRiskHighThreshold),
                                       Risk(operational.get(MEDIUM), operationalRiskMediumThreshold),
                                       Risk(operational.get(LOW), operationalRiskLowThreshold),
                                       Risk(operational.get(OK), None))

add_comment("Last Analysis Time: {}".format(risk_profile_view.bomLastUpdatedAt))

print "|   | High  | Medium   | Low   |  None  |"
print "|---|---|---|---|---|"
security_risk_profile.pretty_print()
license_risk_profile.pretty_print()
operational_risk_profile.pretty_print()
print "\n"
print "Policy Status: "
print policy_status
print "\n"

policy_status_json_string = """{'Policy-status' : '"""+ policy_status+"""' }"""
policy_status_json = yaml.load(policy_status_json_string)

is_code_compliant = security_risk_profile.validate() and license_risk_profile.validate() and operational_risk_profile.validate()
project_version_url = hub_services_helper.get_project_version_url_by_id(hub_services_helper.get_project_version_id_by_view(version_view))


compliance_data = {}
compliance_data.update(security_risk_profile.pretty_json())
compliance_data.update(license_risk_profile.pretty_json())
compliance_data.update(operational_risk_profile.pretty_json())
compliance_data.update(policy_status_json)

add_code_compliance_record(analysis_date=risk_profile_view.bomLastUpdatedAt,
                          outcome=("PASSED" if is_code_compliant else "FAILED"),
                          compliance_data=compliance_data,
                          project_url=project_version_url)
if not is_code_compliant:
    raise RuntimeError("Risks are not allowed")
