/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.credentials;

import com.synopsys.integration.builder.AbstractBuilder;
import com.synopsys.integration.encryption.PasswordEncrypter;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.credentials.CredentialsValidator;
import com.synopsys.integration.validator.AbstractValidator;
import org.apache.commons.lang3.StringUtils;

public class CredentialsBuilder
extends AbstractBuilder<Credentials> {
    private String username;
    private String password;
    private int passwordLength;

    @Override
    public Credentials buildObject() {
        Credentials creds = null;
        if (StringUtils.isNotBlank((CharSequence)this.password) && this.passwordLength == 0) {
            String encryptedPassword = null;
            try {
                encryptedPassword = PasswordEncrypter.encrypt(this.password);
            }
            catch (EncryptionException e) {
                throw new IllegalArgumentException(e);
            }
            creds = new Credentials(this.username, encryptedPassword, this.password.length());
        } else {
            creds = new Credentials(this.username, this.password, this.passwordLength);
        }
        return creds;
    }

    @Override
    public AbstractValidator createValidator() {
        CredentialsValidator validator = new CredentialsValidator();
        validator.setUsername(this.getUsername());
        validator.setPassword(this.getPassword());
        return validator;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }
}

