/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio;

import com.synopsys.integration.hub.bdio.graph.DependencyGraph;
import com.synopsys.integration.hub.bdio.graph.MutableMapDependencyGraph;
import com.synopsys.integration.hub.bdio.model.BdioComponent;
import com.synopsys.integration.hub.bdio.model.BdioProject;
import com.synopsys.integration.hub.bdio.model.BdioRelationship;
import com.synopsys.integration.hub.bdio.model.Forge;
import com.synopsys.integration.hub.bdio.model.dependency.Dependency;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BdioTransformer {
    private final Map<String, Forge> forgeMap;

    public BdioTransformer() {
        this.forgeMap = Forge.FORGE_NAME_TO_FORGE;
    }

    public BdioTransformer(Map<String, Forge> forgeMap) {
        this.forgeMap = forgeMap;
    }

    public DependencyGraph transformToDependencyGraph(BdioProject project, List<BdioComponent> components) {
        MutableMapDependencyGraph dependencyGraph = new MutableMapDependencyGraph();
        HashMap<String, Dependency> bdioIdToDependencyMap = new HashMap<String, Dependency>();
        for (BdioComponent component : components) {
            ExternalId externalId = component.bdioExternalIdentifier.externalIdMetaData;
            if (externalId == null) {
                Forge forge = this.forgeMap.get(component.bdioExternalIdentifier.forge);
                externalId = this.recreateExternalId(forge, component.bdioExternalIdentifier.externalId, component.name, component.version);
            }
            Dependency dependency = new Dependency(component.name, component.version, externalId);
            bdioIdToDependencyMap.put(component.id, dependency);
        }
        for (BdioRelationship relation : project.relationships) {
            dependencyGraph.addChildrenToRoot((Dependency)bdioIdToDependencyMap.get(relation.related));
        }
        for (BdioComponent component : components) {
            Dependency dependency = (Dependency)bdioIdToDependencyMap.get(component.id);
            for (BdioRelationship relation : component.relationships) {
                dependencyGraph.addParentWithChild(dependency, (Dependency)bdioIdToDependencyMap.get(relation.related));
            }
        }
        return dependencyGraph;
    }

    private ExternalId recreateExternalId(Forge forge, String fullExternalId, String name, String revision) {
        String[] pieces = StringUtils.split((String)fullExternalId, (String)forge.getSeparator());
        ExternalId id = new ExternalId(forge);
        if (pieces.length == 1) {
            id.path = pieces[0];
        } else if (pieces.length == 2 || pieces.length == 3) {
            if (pieces[0].equals(name)) {
                id.name = pieces[0];
                id.version = pieces[1];
                if (pieces.length > 2) {
                    id.architecture = pieces[2];
                }
            } else if (pieces[1].equals(name) && pieces[2].equals(revision)) {
                id.group = pieces[0];
                id.name = pieces[1];
                id.version = pieces[2];
            } else {
                id.moduleNames = pieces;
            }
        } else {
            id.moduleNames = pieces;
        }
        return id;
    }
}

