/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.request;

import com.synopsys.integration.exception.IntegrationException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

public class Response
implements Closeable {
    public static final String LAST_MODIFIED_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String LAST_MODIFIED_HEADER_KEY = "Last-Modified";
    private final CloseableHttpResponse response;

    public Response(CloseableHttpResponse response) {
        this.response = response;
    }

    public Integer getStatusCode() {
        if (this.response.getStatusLine() != null) {
            return this.response.getStatusLine().getStatusCode();
        }
        return null;
    }

    public String getStatusMessage() {
        if (this.response.getStatusLine() != null) {
            return this.response.getStatusLine().getReasonPhrase();
        }
        return null;
    }

    public InputStream getContent() throws IntegrationException {
        if (this.response.getEntity() != null) {
            try {
                return this.response.getEntity().getContent();
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new IntegrationException(e.getMessage(), e);
            }
        }
        return null;
    }

    public String getContentString() throws IntegrationException {
        return this.getContentString(Charsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContentString(Charset encoding) throws IntegrationException {
        if (this.response.getEntity() == null) return null;
        try (InputStream inputStream = this.response.getEntity().getContent();){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)encoding);
            return string;
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public Long getContentLength() {
        if (this.response.getEntity() != null) {
            return this.response.getEntity().getContentLength();
        }
        return null;
    }

    public String getContentEncoding() {
        if (this.response.getEntity() != null && this.response.getEntity().getContentEncoding() != null) {
            return this.response.getEntity().getContentEncoding().getValue();
        }
        return null;
    }

    public String getContentType() {
        if (this.response.getEntity() != null && this.response.getEntity().getContentType() != null) {
            return this.response.getEntity().getContentType().getValue();
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.response.getAllHeaders() != null && this.response.getAllHeaders().length > 0) {
            for (Header header : this.response.getAllHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
        }
        return headers;
    }

    public String getHeaderValue(String name) {
        if (this.response.containsHeader(name)) {
            return this.response.getFirstHeader(name).getValue();
        }
        return null;
    }

    public CloseableHttpResponse getActualResponse() {
        return this.response;
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }

    public long getLastModified() throws IntegrationException {
        String lastModified = this.getHeaderValue(LAST_MODIFIED_HEADER_KEY);
        long lastModifiedLong = 0L;
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(LAST_MODIFIED_FORMAT, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date parsed = format.parse(lastModified);
                lastModifiedLong = parsed.getTime();
            }
            catch (ParseException e) {
                throw new IntegrationException("Could not parse the last modified date : " + e.getMessage());
            }
        }
        return lastModifiedLong;
    }
}

