/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.request.Response;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class BinaryScannerService
extends DataService {
    public BinaryScannerService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
    }

    public void scanBinary(File binaryFile, String projectName, String projectVersion, String codeLocatioName) throws IntegrationException, MalformedURLException, URISyntaxException {
        RequestBuilder builder = this.hubService.getRestConnection().createRequestBuilder(HttpMethod.POST);
        URL uploadUrl = new URL(this.hubService.getRestConnection().getBaseUrl(), "/api/uploads");
        builder.setUri(uploadUrl.toURI());
        builder.setEntity(this.createEntity(binaryFile, projectName, projectVersion, codeLocatioName));
        Response response = this.hubService.getRestConnection().executeRequest(builder.build());
        this.logger.debug("Response: " + response.toString());
        this.logger.debug("Response: " + response.getStatusMessage().toString());
        this.logger.debug("Response: " + response.getStatusCode().toString());
        this.logger.debug("Response: " + response.getContentString());
        if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
            this.logger.error("Unknown status code: " + response.getStatusCode());
            throw new IntegrationException("Unkown status code when uploading binary scan: " + response.getStatusCode() + ", " + response.getStatusMessage());
        }
        this.logger.info("Status code OK");
    }

    private HttpEntity createEntity(File file, String projectName, String projectVersion, String codeLocatioName) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        this.addPart(builder, "projectName", projectName);
        this.addPart(builder, "version", projectVersion);
        this.addPart(builder, "codeLocationName", codeLocatioName);
        builder.addBinaryBody("fileupload", file);
        return builder.build();
    }

    private void addPart(MultipartEntityBuilder builder, String name, String value) {
        StringBody body = new StringBody(value, ContentType.DEFAULT_TEXT);
        FormBodyPart part = FormBodyPartBuilder.create((String)name, (ContentBody)body).build();
        builder.addPart(part);
    }
}

