/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio.graph;

import com.synopsys.integration.hub.bdio.BdioNodeFactory;
import com.synopsys.integration.hub.bdio.BdioPropertyHelper;
import com.synopsys.integration.hub.bdio.graph.DependencyGraph;
import com.synopsys.integration.hub.bdio.model.BdioComponent;
import com.synopsys.integration.hub.bdio.model.BdioExternalIdentifier;
import com.synopsys.integration.hub.bdio.model.BdioNode;
import com.synopsys.integration.hub.bdio.model.dependency.Dependency;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraphTransformer {
    private final BdioPropertyHelper bdioPropertyHelper;
    private final BdioNodeFactory bdioNodeFactory;

    public DependencyGraphTransformer(BdioPropertyHelper bdioPropertyHelper, BdioNodeFactory bdioNodeFactory) {
        this.bdioPropertyHelper = bdioPropertyHelper;
        this.bdioNodeFactory = bdioNodeFactory;
    }

    public List<BdioComponent> transformDependencyGraph(DependencyGraph graph, BdioNode currentNode, Set<Dependency> dependencies, Map<ExternalId, BdioNode> existingComponents) {
        ArrayList<BdioComponent> addedComponents = new ArrayList<BdioComponent>();
        for (Dependency dependency : dependencies) {
            if (!existingComponents.containsKey(dependency.externalId)) {
                BdioComponent addedNode = this.componentFromDependency(dependency);
                addedComponents.add(addedNode);
                existingComponents.put(dependency.externalId, addedNode);
                List<BdioComponent> addedChildren = this.transformDependencyGraph(graph, addedNode, graph.getChildrenForParent(dependency), existingComponents);
                addedComponents.addAll(addedChildren);
            }
            this.bdioPropertyHelper.addRelationship(currentNode, existingComponents.get(dependency.externalId));
        }
        return addedComponents;
    }

    private BdioComponent componentFromDependency(Dependency dependency) {
        String componentName = dependency.name;
        String componentVersion = dependency.version;
        String componentId = dependency.externalId.createBdioId();
        BdioExternalIdentifier componentExternalIdentifier = this.bdioPropertyHelper.createExternalIdentifier(dependency.externalId);
        BdioComponent component = this.bdioNodeFactory.createComponent(componentName, componentVersion, componentId, componentExternalIdentifier);
        return component;
    }
}

