/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner.command;

import java.util.Set;

public class ScanTarget {
    private final String path;
    private final Set<String> exclusionPatterns;
    private final String codeLocationName;
    private final String outputDirectoryPath;
    private final boolean outputDirectoryPathAbsolute;

    public static ScanTarget createBasicTarget(String path) {
        return new ScanTarget(path, null, null, null, false);
    }

    public static ScanTarget createBasicTarget(String path, Set<String> exclusionPatterns, String codeLocationName) {
        return new ScanTarget(path, exclusionPatterns, codeLocationName, null, false);
    }

    private ScanTarget(String path, Set<String> exclusionPatterns, String codeLocationName, String outputDirectoryPath, boolean outputDirectoryPathAbsolute) {
        this.path = path;
        this.exclusionPatterns = exclusionPatterns;
        this.codeLocationName = codeLocationName;
        this.outputDirectoryPath = outputDirectoryPath;
        this.outputDirectoryPathAbsolute = outputDirectoryPathAbsolute;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public String getCodeLocationName() {
        return this.codeLocationName;
    }

    public String getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    public boolean isOutputDirectoryPathAbsolute() {
        return this.outputDirectoryPathAbsolute;
    }

    public static class Builder {
        private String path;
        private Set<String> exclusionPatterns;
        private String codeLocationName;
        private String outputDirectoryPath;
        private boolean outputDirectoryPathAbsolute;

        public Builder(String path) {
            this.path = path;
        }

        public ScanTarget build() {
            return new ScanTarget(this.path, this.exclusionPatterns, this.codeLocationName, this.outputDirectoryPath, this.outputDirectoryPathAbsolute);
        }

        public String getPath() {
            return this.path;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Set<String> getExclusionPatterns() {
            return this.exclusionPatterns;
        }

        public Builder exclusionPatterns(Set<String> exclusionPatterns) {
            this.exclusionPatterns = exclusionPatterns;
            return this;
        }

        public String getCodeLocationName() {
            return this.codeLocationName;
        }

        public Builder codeLocationName(String codeLocationName) {
            this.codeLocationName = codeLocationName;
            return this;
        }

        public String getOutputDirectoryPath() {
            return this.outputDirectoryPath;
        }

        public Builder outputDirectoryPath(String outputDirectoryPath) {
            this.outputDirectoryPath = outputDirectoryPath;
            return this;
        }

        public boolean isOutputDirectoryPathAbsolute() {
            return this.outputDirectoryPathAbsolute;
        }

        public Builder outputDirectoryPathAbsolute(boolean outputDirectoryPathAbsolute) {
            this.outputDirectoryPathAbsolute = outputDirectoryPathAbsolute;
            return this;
        }

        public Builder outputDirectoryPath(String outputDirectoryPath, boolean isAbsolute) {
            this.outputDirectoryPath = outputDirectoryPath;
            this.outputDirectoryPathAbsolute = isAbsolute;
            return this;
        }
    }
}

