/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.configuration.HubServerConfig;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.certificate.CertificateHandler;
import java.io.File;

public class HubCertificateHandler {
    private final CertificateHandler handler;

    public HubCertificateHandler(IntLogger logger) {
        this.handler = new CertificateHandler(logger);
    }

    public HubCertificateHandler(IntLogger logger, File javaHomeOverride) {
        this.handler = new CertificateHandler(logger, javaHomeOverride);
    }

    public void importHttpsCertificateForHubServer(HubServerConfig hubServerConfig) throws IntegrationException {
        if (hubServerConfig == null || hubServerConfig.getHubUrl() == null || !hubServerConfig.getHubUrl().getProtocol().startsWith("https")) {
            return;
        }
        this.handler.setTimeout(hubServerConfig.getTimeout());
        if (hubServerConfig.getProxyInfo() != null) {
            this.handler.setProxyInfo(hubServerConfig.getProxyInfo());
        }
        if (this.handler.isCertificateInTrustStore(hubServerConfig.getHubUrl())) {
            return;
        }
        this.handler.retrieveAndImportHttpsCertificate(hubServerConfig.getHubUrl());
    }
}

