/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.bucket;

import com.synopsys.integration.blackduck.api.UriSingleResponse;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.bucket.HubBucket;
import com.synopsys.integration.blackduck.service.bucket.HubBucketFillTask;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class HubBucketService
extends DataService {
    private final Optional<ExecutorService> executorService;

    public HubBucketService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
        this.executorService = Optional.empty();
    }

    public HubBucketService(HubService hubService, IntLogger logger, ExecutorService executorService) {
        super(hubService, logger);
        this.executorService = Optional.of(executorService);
    }

    public HubBucket startTheBucket(List<UriSingleResponse<? extends HubResponse>> uriSingleResponses) throws IntegrationException {
        HubBucket hubBucket = new HubBucket();
        this.addToTheBucket(hubBucket, uriSingleResponses);
        return hubBucket;
    }

    public <T extends HubResponse> void addToTheBucket(HubBucket hubBucket, String uri, Class<T> responseClass) throws IntegrationException {
        ArrayList<UriSingleResponse<? extends HubResponse>> uriSingleResponses = new ArrayList<UriSingleResponse<? extends HubResponse>>();
        uriSingleResponses.add(new UriSingleResponse<T>(uri, responseClass));
        this.addToTheBucket(hubBucket, uriSingleResponses);
    }

    public void addToTheBucket(HubBucket hubBucket, Map<String, Class<? extends HubResponse>> uriToResponseClass) throws IntegrationException {
        ArrayList<UriSingleResponse<? extends HubResponse>> uriSingleResponses = new ArrayList<UriSingleResponse<? extends HubResponse>>();
        uriToResponseClass.forEach((key, value) -> uriSingleResponses.add(new UriSingleResponse((String)key, value)));
        this.addToTheBucket(hubBucket, uriSingleResponses);
    }

    public void addToTheBucket(HubBucket hubBucket, List<UriSingleResponse<? extends HubResponse>> uriSingleResponses) throws IntegrationException {
        List<HubBucketFillTask> taskList = uriSingleResponses.stream().map(uriSingleResponse -> new HubBucketFillTask(this.hubService, hubBucket, (UriSingleResponse<? extends HubResponse>)uriSingleResponse)).collect(Collectors.toList());
        if (this.executorService.isPresent()) {
            taskList.forEach(task -> this.executorService.get().execute((Runnable)task));
        } else {
            taskList.forEach(task -> task.run());
        }
    }
}

