/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.synopsys.integration.blackduck.api.generated.component.RiskCountView;
import com.synopsys.integration.blackduck.api.generated.enumeration.PolicySummaryStatusType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ReportFormatType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ReportType;
import com.synopsys.integration.blackduck.api.generated.enumeration.RiskCountType;
import com.synopsys.integration.blackduck.api.generated.view.PolicyRuleViewV2;
import com.synopsys.integration.blackduck.api.generated.view.PolicyStatusView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.generated.view.ReportView;
import com.synopsys.integration.blackduck.api.generated.view.VersionBomComponentView;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.report.RiskReportWriter;
import com.synopsys.integration.blackduck.report.api.BomComponent;
import com.synopsys.integration.blackduck.report.api.PolicyRule;
import com.synopsys.integration.blackduck.report.api.ReportData;
import com.synopsys.integration.blackduck.report.exception.RiskReportException;
import com.synopsys.integration.blackduck.report.pdf.RiskReportPdfWriter;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.ProjectService;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import com.synopsys.integration.util.IntegrationEscapeUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ReportService
extends DataService {
    public static final long DEFAULT_TIMEOUT = 300000L;
    private final ProjectService projectDataService;
    private final IntegrationEscapeUtil escapeUtil;
    private final long timeoutInMilliseconds;

    public ReportService(HubService hubService, IntLogger logger, ProjectService projectDataService, IntegrationEscapeUtil escapeUtil) {
        this(hubService, logger, projectDataService, escapeUtil, 300000L);
    }

    public ReportService(HubService hubService, IntLogger logger, ProjectService projectDataService, IntegrationEscapeUtil escapeUtil, long timeoutInMilliseconds) {
        super(hubService, logger);
        this.projectDataService = projectDataService;
        this.escapeUtil = escapeUtil;
        long timeout = timeoutInMilliseconds;
        if (timeoutInMilliseconds <= 0L) {
            timeout = 300000L;
            this.logger.alwaysLog(timeoutInMilliseconds + "ms is not a valid BOM wait time, using : " + timeout + "ms instead");
        }
        this.timeoutInMilliseconds = timeout;
    }

    public String getNoticesReportData(String projectName, String projectVersionName) throws InterruptedException, IntegrationException {
        ProjectView project = this.projectDataService.getProjectByName(projectName);
        ProjectVersionView version = this.projectDataService.getProjectVersion(project, projectVersionName);
        return this.getNoticesReportData(project, version);
    }

    public String getNoticesReportData(ProjectView project, ProjectVersionView version) throws InterruptedException, IntegrationException {
        this.logger.trace("Getting the Notices Report Contents using the Report Rest Server");
        return this.generateHubNoticesReport(version, ReportFormatType.TEXT);
    }

    public File createNoticesReportFile(File outputDirectory, String projectName, String projectVersionName) throws InterruptedException, IntegrationException {
        return this.createNoticesReportFile(outputDirectory, this.getNoticesReportData(projectName, projectVersionName), projectName, projectVersionName);
    }

    public File createNoticesReportFile(File outputDirectory, ProjectView project, ProjectVersionView version) throws InterruptedException, IntegrationException {
        return this.createNoticesReportFile(outputDirectory, this.getNoticesReportData(project, version), project.name, version.versionName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createNoticesReportFile(File outputDirectory, String noticesReportContent, String projectName, String projectVersionName) throws HubIntegrationException {
        if (noticesReportContent == null) {
            return null;
        }
        String escapedProjectName = this.escapeUtil.escapeForUri(projectName);
        String escapedProjectVersionName = this.escapeUtil.escapeForUri(projectVersionName);
        File noticesReportFile = new File(outputDirectory, escapedProjectName + "_" + escapedProjectVersionName + "_Hub_Notices_Report.txt");
        if (noticesReportFile.exists()) {
            noticesReportFile.delete();
        }
        try (FileWriter writer = new FileWriter(noticesReportFile);){
            this.logger.trace("Creating Notices Report in : " + outputDirectory.getCanonicalPath());
            writer.write(noticesReportContent);
            this.logger.trace("Created Notices Report : " + noticesReportFile.getCanonicalPath());
            File file = noticesReportFile;
            return file;
        }
        catch (IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    public ReportData getRiskReportData(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView project = this.projectDataService.getProjectByName(projectName);
        ProjectVersionView version = this.projectDataService.getProjectVersion(project, projectVersionName);
        return this.getRiskReportData(project, version);
    }

    public ReportData getRiskReportData(ProjectView project, ProjectVersionView version) throws IntegrationException {
        String originalProjectUrl = this.hubService.getHref(project);
        String originalVersionUrl = this.hubService.getHref(version);
        ReportData reportData = new ReportData();
        reportData.setProjectName(project.name);
        reportData.setProjectURL(this.getReportProjectUrl(originalProjectUrl));
        reportData.setProjectVersion(version.versionName);
        reportData.setProjectVersionURL(this.getReportVersionUrl(originalVersionUrl, false));
        reportData.setPhase(version.phase.toString());
        reportData.setDistribution(version.distribution.toString());
        ArrayList<BomComponent> components = new ArrayList<BomComponent>();
        this.logger.trace("Getting the Report Contents using the Aggregate Bom Rest Server");
        List<VersionBomComponentView> bomEntries = this.hubService.getAllResponses(version, ProjectVersionView.COMPONENTS_LINK_RESPONSE);
        boolean policyFailure = false;
        for (VersionBomComponentView bomEntry : bomEntries) {
            BomComponent component = this.createBomComponentFromBomComponentView(bomEntry);
            String policyStatus = bomEntry.approvalStatus.toString();
            if (StringUtils.isBlank((CharSequence)policyStatus)) {
                String componentPolicyStatusURL = null;
                componentPolicyStatusURL = !StringUtils.isBlank((CharSequence)bomEntry.componentVersion) ? this.getComponentPolicyURL(originalVersionUrl, bomEntry.componentVersion) : this.getComponentPolicyURL(originalVersionUrl, bomEntry.component);
                if (!policyFailure) {
                    try {
                        PolicyStatusView bomPolicyStatus = this.hubService.getResponse(componentPolicyStatusURL, PolicyStatusView.class);
                        policyStatus = bomPolicyStatus.approvalStatus.toString();
                    }
                    catch (IntegrationException e) {
                        policyFailure = true;
                        this.logger.debug("Could not get the component policy status, the Hub policy module is not enabled");
                    }
                }
            }
            component.setPolicyStatus(policyStatus);
            this.populatePolicyRuleInfo(component, bomEntry);
            components.add(component);
        }
        reportData.setComponents(components);
        return reportData;
    }

    public void createReportFiles(File outputDirectory, String projectName, String projectVersionName) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(projectName, projectVersionName);
        this.createReportFiles(outputDirectory, reportData);
    }

    public void createReportFiles(File outputDirectory, ProjectView project, ProjectVersionView version) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(project, version);
        this.createReportFiles(outputDirectory, reportData);
    }

    public void createReportFiles(File outputDirectory, ReportData reportData) throws HubIntegrationException {
        try {
            this.logger.trace("Creating Risk Report Files in : " + outputDirectory.getCanonicalPath());
            RiskReportWriter writer = new RiskReportWriter();
            writer.createHtmlReportFiles(outputDirectory, reportData);
        }
        catch (RiskReportException | IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    public File createReportPdfFile(File outputDirectory, String projectName, String projectVersionName) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(projectName, projectVersionName);
        return this.createReportPdfFile(outputDirectory, reportData);
    }

    public File createReportPdfFile(File outputDirectory, ProjectView project, ProjectVersionView version) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(project, version);
        return this.createReportPdfFile(outputDirectory, reportData);
    }

    public File createReportPdfFile(File outputDirectory, ReportData reportData) throws HubIntegrationException {
        try {
            this.logger.trace("Creating Risk Report Pdf in : " + outputDirectory.getCanonicalPath());
            RiskReportPdfWriter writer = new RiskReportPdfWriter(this.logger);
            File pdfFile = writer.createPDFReportFile(outputDirectory, reportData);
            this.logger.trace("Created Risk Report Pdf : " + pdfFile.getCanonicalPath());
            return pdfFile;
        }
        catch (RiskReportException | IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    private String getComponentPolicyURL(String versionURL, String componentURL) {
        String componentVersionSegments = componentURL.substring(componentURL.indexOf("components"));
        return versionURL + "/" + componentVersionSegments + "/policy-status";
    }

    private BomComponent createBomComponentFromBomComponentView(VersionBomComponentView bomEntry) {
        BomComponent component = new BomComponent();
        component.setComponentName(bomEntry.componentName);
        component.setComponentURL(this.getReportProjectUrl(bomEntry.component));
        component.setComponentVersion(bomEntry.componentVersionName);
        component.setComponentVersionURL(this.getReportVersionUrl(bomEntry.componentVersion, true));
        component.setLicense(bomEntry.licenses.get((int)0).licenseDisplay);
        if (bomEntry.securityRiskProfile != null && bomEntry.securityRiskProfile.counts != null && !bomEntry.securityRiskProfile.counts.isEmpty()) {
            for (RiskCountView count : bomEntry.securityRiskProfile.counts) {
                if (count.countType == RiskCountType.HIGH && count.count > 0) {
                    component.setSecurityRiskHighCount(count.count);
                    continue;
                }
                if (count.countType == RiskCountType.MEDIUM && count.count > 0) {
                    component.setSecurityRiskMediumCount(count.count);
                    continue;
                }
                if (count.countType != RiskCountType.LOW || count.count <= 0) continue;
                component.setSecurityRiskLowCount(count.count);
            }
        }
        if (bomEntry.licenseRiskProfile != null && bomEntry.licenseRiskProfile.counts != null && !bomEntry.licenseRiskProfile.counts.isEmpty()) {
            for (RiskCountView count : bomEntry.licenseRiskProfile.counts) {
                if (count.countType == RiskCountType.HIGH && count.count > 0) {
                    component.setLicenseRiskHighCount(count.count);
                    continue;
                }
                if (count.countType == RiskCountType.MEDIUM && count.count > 0) {
                    component.setLicenseRiskMediumCount(count.count);
                    continue;
                }
                if (count.countType != RiskCountType.LOW || count.count <= 0) continue;
                component.setLicenseRiskLowCount(count.count);
            }
        }
        if (bomEntry.operationalRiskProfile != null && bomEntry.operationalRiskProfile.counts != null && !bomEntry.operationalRiskProfile.counts.isEmpty()) {
            for (RiskCountView count : bomEntry.operationalRiskProfile.counts) {
                if (count.countType == RiskCountType.HIGH && count.count > 0) {
                    component.setOperationalRiskHighCount(count.count);
                    continue;
                }
                if (count.countType == RiskCountType.MEDIUM && count.count > 0) {
                    component.setOperationalRiskMediumCount(count.count);
                    continue;
                }
                if (count.countType != RiskCountType.LOW || count.count <= 0) continue;
                component.setOperationalRiskLowCount(count.count);
            }
        }
        return component;
    }

    public void populatePolicyRuleInfo(BomComponent component, VersionBomComponentView bomEntry) throws IntegrationException {
        PolicySummaryStatusType status;
        if (bomEntry != null && bomEntry.approvalStatus != null && (status = bomEntry.approvalStatus) == PolicySummaryStatusType.IN_VIOLATION) {
            List<PolicyRuleViewV2> rules = this.hubService.getAllResponses(bomEntry, VersionBomComponentView.POLICY_RULES_LINK_RESPONSE);
            ArrayList<PolicyRule> rulesViolated = new ArrayList<PolicyRule>();
            for (PolicyRuleViewV2 policyRuleView : rules) {
                PolicyRule ruleViolated = new PolicyRule();
                ruleViolated.setName(policyRuleView.name);
                ruleViolated.setDescription(policyRuleView.description);
                rulesViolated.add(ruleViolated);
            }
            component.setPolicyRulesViolated(rulesViolated);
        }
    }

    private String getBaseUrl() {
        return this.hubService.getHubBaseUrl().toString();
    }

    private String getReportProjectUrl(String projectURL) {
        if (projectURL == null) {
            return null;
        }
        String projectId = projectURL.substring(projectURL.lastIndexOf("/") + 1);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("projects/id:");
        urlBuilder.append(projectId);
        return urlBuilder.toString();
    }

    private String getReportVersionUrl(String versionURL, boolean isComponent) {
        if (versionURL == null) {
            return null;
        }
        String versionId = versionURL.substring(versionURL.lastIndexOf("/") + 1);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("versions/id:");
        urlBuilder.append(versionId);
        if (!isComponent) {
            urlBuilder.append("/view:bom");
        }
        return urlBuilder.toString();
    }

    public String generateHubNoticesReport(ProjectVersionView version, ReportFormatType reportFormat) throws InterruptedException, IntegrationException {
        block5: {
            if (this.hubService.hasLink(version, "licenseReports")) {
                try {
                    this.logger.debug("Starting the Notices Report generation.");
                    String reportUrl = this.startGeneratingHubNoticesReport(version, reportFormat);
                    this.logger.debug("Waiting for the Notices Report to complete.");
                    ReportView reportInfo = this.isReportFinishedGenerating(reportUrl);
                    String contentLink = this.hubService.getFirstLink(reportInfo, "content");
                    if (contentLink == null) {
                        throw new HubIntegrationException("Could not find content link for the report at : " + reportUrl);
                    }
                    this.logger.debug("Getting the Notices Report content.");
                    String noticesReport = this.getNoticesReportContent(contentLink);
                    this.logger.debug("Finished retrieving the Notices Report.");
                    this.logger.debug("Cleaning up the Notices Report on the server.");
                    this.deleteHubReport(reportUrl);
                    return noticesReport;
                }
                catch (IntegrationRestException e) {
                    if (e.getHttpStatusCode() == 402) {
                        this.logger.warn("Can not create the notice report, the Hub notice module is not enabled.");
                        break block5;
                    }
                    throw e;
                }
            }
            this.logger.warn("Can not create the notice report, the Hub notice module is not enabled.");
        }
        return null;
    }

    public String startGeneratingHubNoticesReport(ProjectVersionView version, ReportFormatType reportFormat) throws IntegrationException {
        String reportUri = this.hubService.getFirstLink(version, "licenseReports");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("reportFormat", reportFormat.toString());
        jsonObject.addProperty("reportType", ReportType.VERSION_LICENSE.toString());
        String json = this.hubService.convertToJson(jsonObject);
        Request request = RequestFactory.createCommonPostRequestBuilder(json).uri(reportUri).build();
        return this.hubService.executePostRequestAndRetrieveURL(request);
    }

    public ReportView isReportFinishedGenerating(String reportUri) throws InterruptedException, IntegrationException {
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        Date timeFinished = null;
        ReportView reportInfo = null;
        while (timeFinished == null) {
            reportInfo = this.hubService.getResponse(reportUri, ReportView.class);
            timeFinished = reportInfo.finishedAt;
            if (timeFinished != null) break;
            if (elapsedTime >= this.timeoutInMilliseconds) {
                String formattedTime = String.format("%d minutes", TimeUnit.MILLISECONDS.toMinutes(this.timeoutInMilliseconds));
                throw new HubIntegrationException("The Report has not finished generating in : " + formattedTime);
            }
            Thread.sleep(5000L);
            elapsedTime = System.currentTimeMillis() - startTime;
        }
        return reportInfo;
    }

    public String getNoticesReportContent(String reportContentUri) throws IntegrationException {
        JsonElement fileContent = this.getReportContentJson(reportContentUri);
        return fileContent.getAsString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonElement getReportContentJson(String reportContentUri) throws IntegrationException {
        try (Response response = this.hubService.executeGetRequest(reportContentUri);){
            String jsonResponse = response.getContentString();
            JsonObject json = this.hubService.getJsonParser().parse(jsonResponse).getAsJsonObject();
            JsonElement content = json.get("reportContent");
            JsonArray reportConentArray = content.getAsJsonArray();
            JsonObject reportFile = reportConentArray.get(0).getAsJsonObject();
            JsonElement jsonElement = reportFile.get("fileContent");
            return jsonElement;
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public void deleteHubReport(String reportUri) throws IntegrationException {
        Request request = new Request.Builder(reportUri).method(HttpMethod.DELETE).build();
        try {
            Response response = this.hubService.executeRequest(request);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }
}

