/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.notification.content.detail;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.synopsys.integration.blackduck.api.component.AffectedProjectVersion;
import com.synopsys.integration.blackduck.api.generated.enumeration.NotificationType;
import com.synopsys.integration.blackduck.notification.CommonNotificationView;
import com.synopsys.integration.blackduck.notification.NotificationDetailResult;
import com.synopsys.integration.blackduck.notification.content.BomEditContent;
import com.synopsys.integration.blackduck.notification.content.ComponentVersionStatus;
import com.synopsys.integration.blackduck.notification.content.NotificationContent;
import com.synopsys.integration.blackduck.notification.content.PolicyInfo;
import com.synopsys.integration.blackduck.notification.content.PolicyOverrideNotificationContent;
import com.synopsys.integration.blackduck.notification.content.RuleViolationClearedNotificationContent;
import com.synopsys.integration.blackduck.notification.content.RuleViolationNotificationContent;
import com.synopsys.integration.blackduck.notification.content.VulnerabilityNotificationContent;
import com.synopsys.integration.blackduck.notification.content.detail.NotificationContentDetail;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class NotificationContentDetailFactory {
    private final Gson gson;
    private final JsonParser jsonParser;

    public NotificationContentDetailFactory(Gson gson, JsonParser jsonParser) {
        this.gson = gson;
        this.jsonParser = jsonParser;
    }

    public NotificationDetailResult generateContentDetails(CommonNotificationView view) {
        NotificationType type = view.getType();
        String notificationJson = view.json;
        JsonObject jsonObject = this.jsonParser.parse(notificationJson).getAsJsonObject();
        NotificationContent notificationContent = null;
        String notificationGroup = null;
        ArrayList<NotificationContentDetail> notificationContentDetails = new ArrayList<NotificationContentDetail>();
        if (NotificationType.POLICY_OVERRIDE.equals((Object)type)) {
            notificationContent = this.gson.fromJson(jsonObject.get("content"), PolicyOverrideNotificationContent.class);
            notificationGroup = "policy";
            this.populateContentDetails(notificationContentDetails, notificationGroup, (PolicyOverrideNotificationContent)notificationContent);
        } else if (NotificationType.RULE_VIOLATION.equals((Object)type)) {
            notificationContent = this.gson.fromJson(jsonObject.get("content"), RuleViolationNotificationContent.class);
            notificationGroup = "policy";
            this.populateContentDetails(notificationContentDetails, notificationGroup, (RuleViolationNotificationContent)notificationContent);
        } else if (NotificationType.RULE_VIOLATION_CLEARED.equals((Object)type)) {
            notificationContent = this.gson.fromJson(jsonObject.get("content"), RuleViolationClearedNotificationContent.class);
            notificationGroup = "policy";
            this.populateContentDetails(notificationContentDetails, notificationGroup, (RuleViolationClearedNotificationContent)notificationContent);
        } else if (NotificationType.VULNERABILITY.equals((Object)type)) {
            notificationContent = this.gson.fromJson(jsonObject.get("content"), VulnerabilityNotificationContent.class);
            notificationGroup = "vulnerability";
            this.populateContentDetails(notificationContentDetails, notificationGroup, (VulnerabilityNotificationContent)notificationContent);
        } else if (NotificationType.BOM_EDIT.equals((Object)type)) {
            notificationContent = this.gson.fromJson(jsonObject.get("content"), BomEditContent.class);
            notificationGroup = "bom_edit";
            this.populateContentDetails(notificationContentDetails, notificationGroup, (BomEditContent)notificationContent);
        }
        return new NotificationDetailResult(notificationContent, view.getContentType(), view.getCreatedAt(), view.getType(), notificationGroup, Optional.ofNullable(view.getNotificationState()), notificationContentDetails);
    }

    public void populateContentDetails(List<NotificationContentDetail> notificationContentDetails, String notificationGroup, PolicyOverrideNotificationContent content) {
        for (PolicyInfo policyInfo : content.policyInfos) {
            String componentValue = content.componentVersion != null ? null : content.component;
            NotificationContentDetail detail = NotificationContentDetail.createDetail(notificationGroup, Optional.of(content.projectName), Optional.of(content.projectVersionName), Optional.of(content.projectVersion), Optional.of(content.componentName), Optional.ofNullable(componentValue), Optional.ofNullable(content.componentVersionName), Optional.ofNullable(content.componentVersion), Optional.of(policyInfo.policyName), Optional.of(policyInfo.policy), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(content.bomComponent));
            notificationContentDetails.add(detail);
        }
    }

    public void populateContentDetails(List<NotificationContentDetail> notificationContentDetails, String notificationGroup, RuleViolationNotificationContent content) {
        Map<String, String> uriToName = content.policyInfos.stream().collect(Collectors.toMap(policyInfo -> policyInfo.policy, policyInfo -> policyInfo.policyName));
        for (ComponentVersionStatus componentVersionStatus : content.componentVersionStatuses) {
            for (String policyUri : componentVersionStatus.policies) {
                String policyName = uriToName.get(policyUri);
                String componentValue = componentVersionStatus.componentVersion != null ? null : componentVersionStatus.component;
                NotificationContentDetail detail = NotificationContentDetail.createDetail(notificationGroup, Optional.of(content.projectName), Optional.of(content.projectVersionName), Optional.of(content.projectVersion), Optional.of(componentVersionStatus.componentName), Optional.ofNullable(componentValue), Optional.ofNullable(componentVersionStatus.componentVersionName), Optional.ofNullable(componentVersionStatus.componentVersion), Optional.of(policyName), Optional.of(policyUri), Optional.empty(), Optional.ofNullable(componentVersionStatus.componentIssueLink), Optional.empty(), Optional.ofNullable(componentVersionStatus.bomComponent));
                notificationContentDetails.add(detail);
            }
        }
    }

    public void populateContentDetails(List<NotificationContentDetail> notificationContentDetails, String notificationGroup, RuleViolationClearedNotificationContent content) {
        Map<String, String> uriToName = content.policyInfos.stream().collect(Collectors.toMap(policyInfo -> policyInfo.policy, policyInfo -> policyInfo.policyName));
        for (ComponentVersionStatus componentVersionStatus : content.componentVersionStatuses) {
            for (String policyUri : componentVersionStatus.policies) {
                String policyName = uriToName.get(policyUri);
                String componentValue = componentVersionStatus.componentVersion != null ? null : componentVersionStatus.component;
                NotificationContentDetail detail = NotificationContentDetail.createDetail(notificationGroup, Optional.of(content.projectName), Optional.of(content.projectVersionName), Optional.of(content.projectVersion), Optional.of(componentVersionStatus.componentName), Optional.ofNullable(componentValue), Optional.ofNullable(componentVersionStatus.componentVersionName), Optional.ofNullable(componentVersionStatus.componentVersion), Optional.of(policyName), Optional.of(policyUri), Optional.empty(), Optional.of(componentVersionStatus.componentIssueLink), Optional.empty(), Optional.ofNullable(componentVersionStatus.bomComponent));
                notificationContentDetails.add(detail);
            }
        }
    }

    public void populateContentDetails(List<NotificationContentDetail> notificationContentDetails, String notificationGroup, VulnerabilityNotificationContent content) {
        for (AffectedProjectVersion projectVersion : content.affectedProjectVersions) {
            NotificationContentDetail detail = NotificationContentDetail.createDetail(notificationGroup, Optional.of(projectVersion.projectName), Optional.of(projectVersion.projectVersionName), Optional.of(projectVersion.projectVersion), Optional.of(content.componentName), Optional.empty(), Optional.of(content.versionName), Optional.of(content.componentVersion), Optional.empty(), Optional.empty(), Optional.ofNullable(content.componentVersionOriginName), Optional.ofNullable(projectVersion.componentIssueUrl), Optional.ofNullable(content.componentVersionOriginId), Optional.ofNullable(projectVersion.bomComponent));
            notificationContentDetails.add(detail);
        }
    }

    private void populateContentDetails(List<NotificationContentDetail> notificationContentDetails, String notificationGroup, BomEditContent notificationContent) {
        NotificationContentDetail detail = NotificationContentDetail.createDetail(notificationGroup, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(notificationContent.bomComponent));
        notificationContentDetails.add(detail);
    }
}

