/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.proxy;

import com.synopsys.integration.builder.AbstractBuilder;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.credentials.CredentialsBuilder;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.proxy.ProxyInfoValidator;
import com.synopsys.integration.validator.AbstractValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ProxyInfoBuilder
extends AbstractBuilder<ProxyInfo> {
    private String host;
    private String port;
    private String username;
    private String password;
    private int passwordLength;
    private String ignoredProxyHosts;
    private String ntlmDomain;
    private String ntlmWorkstation;

    @Override
    public ProxyInfo buildObject() throws IllegalArgumentException {
        ProxyInfo proxyInfo = null;
        int proxyPort = NumberUtils.toInt((String)this.port);
        if (StringUtils.isNotBlank((CharSequence)this.password) && StringUtils.isNotBlank((CharSequence)this.username)) {
            CredentialsBuilder credBuilder = new CredentialsBuilder();
            credBuilder.setUsername(this.username);
            credBuilder.setPassword(this.password);
            credBuilder.setPasswordLength(this.passwordLength);
            Credentials credResult = (Credentials)credBuilder.build();
            proxyInfo = new ProxyInfo(this.host, proxyPort, credResult, this.ignoredProxyHosts, this.ntlmDomain, this.ntlmWorkstation);
        } else {
            proxyInfo = new ProxyInfo(this.host, proxyPort, null, this.ignoredProxyHosts, this.ntlmDomain, this.ntlmWorkstation);
        }
        return proxyInfo;
    }

    @Override
    public AbstractValidator createValidator() {
        ProxyInfoValidator validator = new ProxyInfoValidator();
        validator.setHost(this.getHost());
        validator.setPort(this.getPort());
        validator.setUsername(this.getUsername());
        validator.setPassword(this.getPassword());
        validator.setPasswordLength(this.getPasswordLength());
        validator.setIgnoredProxyHosts(this.getIgnoredProxyHosts());
        validator.setNtlmDomain(this.ntlmDomain);
        validator.setNtlmWorkstation(this.ntlmWorkstation);
        return validator;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.setPort(String.valueOf(port));
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public String getIgnoredProxyHosts() {
        return this.ignoredProxyHosts;
    }

    public void setIgnoredProxyHosts(String ignoredProxyHosts) {
        this.ignoredProxyHosts = ignoredProxyHosts;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }

    public String getNtlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public void setNtlmWorkstation(String ntlmWorkstation) {
        this.ntlmWorkstation = ntlmWorkstation;
    }
}

