/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome;

import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.phonehome.PhoneHomeClient;
import com.synopsys.integration.phonehome.PhoneHomeRequestBody;
import com.synopsys.integration.util.IntEnvironmentVariables;
import java.net.URL;
import java.util.concurrent.Callable;

public abstract class PhoneHomeCallable
implements Callable<Boolean> {
    private final IntLogger logger;
    private final PhoneHomeClient client;
    private final URL productURL;
    private final String artifactId;
    private final String artifactVersion;
    private final IntEnvironmentVariables intEnvironmentVariables;

    public PhoneHomeCallable(IntLogger logger, PhoneHomeClient client, URL productURL, String artifactId, String artifactVersion, IntEnvironmentVariables intEnvironmentVariables) {
        this.logger = logger;
        this.client = client;
        this.productURL = productURL;
        this.artifactId = artifactId;
        this.artifactVersion = artifactVersion;
        this.intEnvironmentVariables = intEnvironmentVariables;
    }

    public abstract PhoneHomeRequestBody.Builder createPhoneHomeRequestBodyBuilder();

    public PhoneHomeRequestBody createPhoneHomeRequestBody() {
        PhoneHomeRequestBody.Builder phoneHomeRequestBodyBuilder = this.createPhoneHomeRequestBodyBuilder();
        phoneHomeRequestBodyBuilder.setArtifactId(this.artifactId);
        phoneHomeRequestBodyBuilder.setArtifactVersion(this.artifactVersion);
        phoneHomeRequestBodyBuilder.setHostName(this.productURL.toString());
        return phoneHomeRequestBodyBuilder.build();
    }

    @Override
    public Boolean call() throws Exception {
        Boolean result = Boolean.FALSE;
        try {
            this.logger.debug("starting phone home");
            PhoneHomeRequestBody phoneHomeRequestBody = this.createPhoneHomeRequestBody();
            this.client.postPhoneHomeRequest(phoneHomeRequestBody, this.intEnvironmentVariables.getVariables());
            result = Boolean.TRUE;
            this.logger.debug("completed phone home");
        }
        catch (Exception ex) {
            this.logger.debug("Phone home error.", ex);
        }
        return result;
    }
}

