/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.rest.request.Request;
import java.util.HashSet;
import org.apache.commons.lang3.math.NumberUtils;

public class PagedRequest {
    private final Request.Builder requestBuilder;
    private final int offset;
    private final int limit;

    public PagedRequest(Request.Builder requestBuilder) {
        this.requestBuilder = requestBuilder;
        int offset = 0;
        int limit = 100;
        if (requestBuilder.getQueryParameters() != null) {
            if (requestBuilder.getQueryParameters().containsKey("offset")) {
                offset = NumberUtils.toInt((String)requestBuilder.getQueryParameters().get("offset").iterator().next(), (int)0);
            }
            if (requestBuilder.getQueryParameters().containsKey("limit")) {
                limit = NumberUtils.toInt((String)requestBuilder.getQueryParameters().get("limit").iterator().next(), (int)100);
            }
        }
        this.offset = offset;
        this.limit = limit;
    }

    public PagedRequest(Request.Builder requestBuilder, int offset, int limit) {
        this.requestBuilder = requestBuilder;
        this.offset = offset;
        this.limit = limit;
    }

    public Request createRequest() {
        Request request = this.requestBuilder.build();
        HashSet<String> limitValue = new HashSet<String>();
        limitValue.add(String.valueOf(this.getLimit()));
        HashSet<String> offsetValue = new HashSet<String>();
        offsetValue.add(String.valueOf(this.getOffset()));
        request.getQueryParameters().put("limit", limitValue);
        request.getQueryParameters().put("offset", offsetValue);
        return request;
    }

    public Request.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }
}

