/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.configuration;

import com.synopsys.integration.blackduck.configuration.HubServerConfig;
import com.synopsys.integration.blackduck.configuration.HubServerConfigValidator;
import com.synopsys.integration.builder.AbstractBuilder;
import com.synopsys.integration.exception.IntegrationCertificateException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.log.PrintStreamIntLogger;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.credentials.CredentialsBuilder;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.proxy.ProxyInfoBuilder;
import com.synopsys.integration.validator.AbstractValidator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.WordUtils;

public class HubServerConfigBuilder
extends AbstractBuilder<HubServerConfig> {
    public static final String HUB_SERVER_CONFIG_ENVIRONMENT_VARIABLE_PREFIX = "BLACKDUCK_HUB_";
    public static final String HUB_SERVER_CONFIG_PROPERTY_KEY_PREFIX = "blackduck.hub.";
    public static int DEFAULT_TIMEOUT_SECONDS = 120;
    private final HubServerConfigValidator validator;
    private final Map<Property, String> values = new HashMap<Property, String>();
    private IntLogger logger;

    public HubServerConfigBuilder() {
        this(new HubServerConfigValidator());
    }

    public HubServerConfigBuilder(HubServerConfigValidator validator) {
        this.validator = validator;
        EnumSet.allOf(Property.class).forEach(property -> this.values.put((Property)((Object)property), (String)null));
        this.values.put(Property.TIMEOUT, String.valueOf(DEFAULT_TIMEOUT_SECONDS));
    }

    @Override
    public HubServerConfig build() throws IllegalStateException {
        try {
            return (HubServerConfig)super.build();
        }
        catch (IllegalStateException stateException) {
            if (!stateException.getMessage().contains("SunCertPathBuilderException")) {
                throw stateException;
            }
            throw new IntegrationCertificateException(String.format("Please import the certificate for %s into your Java keystore.", this.url()), stateException);
        }
    }

    @Override
    public HubServerConfig buildObject() {
        URL hubURL = null;
        try {
            String tempUrl = this.url();
            if (!tempUrl.endsWith("/")) {
                hubURL = new URL(tempUrl);
            } else {
                tempUrl = tempUrl.substring(0, tempUrl.length() - 1);
                hubURL = new URL(tempUrl);
            }
        }
        catch (MalformedURLException tempUrl) {
            // empty catch block
        }
        ProxyInfo proxyInfo = this.getHubProxyInfo();
        if (StringUtils.isNotBlank((CharSequence)this.apiToken())) {
            return new HubServerConfig(hubURL, this.timeoutSeconds(), this.apiToken(), proxyInfo, this.trustCert());
        }
        Credentials credentials = this.getHubCredentials();
        return new HubServerConfig(hubURL, this.timeoutSeconds(), credentials, proxyInfo, this.trustCert());
    }

    private Credentials getHubCredentials() {
        CredentialsBuilder credentialsBuilder = new CredentialsBuilder();
        credentialsBuilder.setUsername(this.values.get((Object)Property.USERNAME));
        credentialsBuilder.setPassword(this.values.get((Object)Property.PASSWORD));
        credentialsBuilder.setPasswordLength(this.passwordLength());
        return credentialsBuilder.buildObject();
    }

    private ProxyInfo getHubProxyInfo() {
        ProxyInfoBuilder proxyBuilder = new ProxyInfoBuilder();
        proxyBuilder.setHost(this.values.get((Object)Property.PROXY_HOST));
        proxyBuilder.setPort(this.values.get((Object)Property.PROXY_PORT));
        proxyBuilder.setIgnoredProxyHosts(this.values.get((Object)Property.PROXY_IGNORED_HOSTS));
        proxyBuilder.setUsername(this.values.get((Object)Property.PROXY_USERNAME));
        proxyBuilder.setPassword(this.values.get((Object)Property.PROXY_PASSWORD));
        proxyBuilder.setPasswordLength(this.proxyPasswordLength());
        proxyBuilder.setNtlmDomain(this.values.get((Object)Property.PROXY_NTLM_DOMAIN));
        proxyBuilder.setNtlmWorkstation(this.values.get((Object)Property.PROXY_NTLM_WORKSTATION));
        return proxyBuilder.buildObject();
    }

    @Override
    public AbstractValidator createValidator() {
        this.validator.setHubUrl(this.url());
        this.validator.setUsername(this.values.get((Object)Property.USERNAME));
        this.validator.setPassword(this.values.get((Object)Property.PASSWORD));
        this.validator.setPasswordLength(this.passwordLength());
        this.validator.setApiToken(this.apiToken());
        this.validator.setTimeout(this.values.get((Object)Property.TIMEOUT));
        this.validator.setProxyHost(this.values.get((Object)Property.PROXY_HOST));
        this.validator.setProxyPort(this.values.get((Object)Property.PROXY_PORT));
        this.validator.setIgnoredProxyHosts(this.values.get((Object)Property.PROXY_IGNORED_HOSTS));
        this.validator.setProxyUsername(this.values.get((Object)Property.PROXY_USERNAME));
        this.validator.setProxyPassword(this.values.get((Object)Property.PROXY_PASSWORD));
        this.validator.setProxyPasswordLength(this.proxyPasswordLength());
        this.validator.setAlwaysTrustServerCertificate(this.trustCert());
        this.validator.setProxyNtlmDomain(this.values.get((Object)Property.PROXY_NTLM_DOMAIN));
        this.validator.setProxyNtlmWorkstation(this.values.get((Object)Property.PROXY_NTLM_WORKSTATION));
        return this.validator;
    }

    public void setFromProperties(Map<String, String> properties) {
        for (Property configProperty : Property.values()) {
            if (!configProperty.isWithin(properties.keySet())) continue;
            String value = configProperty.getValueFrom(properties);
            String setterMethodName = configProperty.getBuilderPropertySetterName();
            try {
                Method setter = this.getClass().getMethod(setterMethodName, String.class);
                setter.invoke((Object)this, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    public void setFromProperties(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (String propertyName : properties.stringPropertyNames()) {
            propertiesMap.put(propertyName, properties.getProperty(propertyName));
        }
        this.setFromProperties(propertiesMap);
    }

    private String url() {
        return this.values.get((Object)Property.URL);
    }

    private String apiToken() {
        return this.values.get((Object)Property.API_TOKEN);
    }

    private int timeoutSeconds() {
        return NumberUtils.toInt((String)this.values.get((Object)Property.TIMEOUT), (int)DEFAULT_TIMEOUT_SECONDS);
    }

    private int passwordLength() {
        return NumberUtils.toInt((String)this.values.get((Object)Property.PASSWORD_LENGTH), (int)0);
    }

    private int proxyPasswordLength() {
        return NumberUtils.toInt((String)this.values.get((Object)Property.PROXY_PASSWORD_LENGTH), (int)0);
    }

    private boolean trustCert() {
        return Boolean.parseBoolean(this.values.get((Object)Property.TRUST_CERT));
    }

    public IntLogger getLogger() {
        if (this.logger == null) {
            this.logger = new PrintStreamIntLogger(System.out, LogLevel.INFO);
        }
        return this.logger;
    }

    public void setLogger(IntLogger logger) {
        this.logger = logger;
    }

    @Deprecated
    public void setHubUrl(String hubUrl) {
        this.setUrl(hubUrl);
    }

    @Deprecated
    public void setAlwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.setTrustCert(alwaysTrustServerCertificate);
    }

    public void setUrl(String url) {
        this.values.put(Property.URL, url);
    }

    public void setUsername(String username) {
        this.values.put(Property.USERNAME, username);
    }

    public void setPassword(String password) {
        this.values.put(Property.PASSWORD, password);
    }

    public void setPasswordLength(String passwordLength) {
        this.values.put(Property.PASSWORD_LENGTH, passwordLength);
    }

    public void setPasswordLength(int passwordLength) {
        this.setPasswordLength(String.valueOf(passwordLength));
    }

    public void setApiToken(String apiToken) {
        this.values.put(Property.API_TOKEN, apiToken);
    }

    public void setTimeout(String timeout) {
        this.values.put(Property.TIMEOUT, timeout);
    }

    public void setTimeout(int timeout) {
        this.setTimeout(String.valueOf(timeout));
    }

    public void setProxyHost(String proxyHost) {
        this.values.put(Property.PROXY_HOST, proxyHost);
    }

    public void setProxyPort(String proxyPort) {
        this.values.put(Property.PROXY_PORT, proxyPort);
    }

    public void setProxyPort(int proxyPort) {
        this.setProxyPort(String.valueOf(proxyPort));
    }

    public void setProxyIgnoredHosts(String proxyIgnoredHosts) {
        this.values.put(Property.PROXY_IGNORED_HOSTS, proxyIgnoredHosts);
    }

    public void setProxyUsername(String proxyUsername) {
        this.values.put(Property.PROXY_USERNAME, proxyUsername);
    }

    public void setProxyPassword(String proxyPassword) {
        this.values.put(Property.PROXY_PASSWORD, proxyPassword);
    }

    public void setProxyPasswordLength(String proxyPasswordLength) {
        this.values.put(Property.PROXY_PASSWORD_LENGTH, proxyPasswordLength);
    }

    public void setProxyPasswordLength(int proxyPasswordLength) {
        this.setProxyPasswordLength(String.valueOf(proxyPasswordLength));
    }

    public void setProxyNtlmDomain(String proxyNtlmDomain) {
        this.values.put(Property.PROXY_NTLM_DOMAIN, proxyNtlmDomain);
    }

    public void setProxyNtlmWorkstation(String proxyNtlmWorkstation) {
        this.values.put(Property.PROXY_NTLM_WORKSTATION, proxyNtlmWorkstation);
    }

    public void setTrustCert(String trustCert) {
        this.values.put(Property.TRUST_CERT, trustCert);
    }

    public void setTrustCert(boolean trustCert) {
        this.setTrustCert(String.valueOf(trustCert));
    }

    public static enum Property {
        URL,
        USERNAME,
        PASSWORD,
        PASSWORD_LENGTH,
        API_TOKEN,
        TIMEOUT,
        PROXY_HOST,
        PROXY_PORT,
        PROXY_IGNORED_HOSTS,
        PROXY_USERNAME,
        PROXY_PASSWORD,
        PROXY_PASSWORD_LENGTH,
        PROXY_NTLM_DOMAIN,
        PROXY_NTLM_WORKSTATION,
        TRUST_CERT;

        private final String environmentVariableKey;
        private final String propertyKey;
        private final String builderPropertyName;
        private final String builderPropertySetterName;

        private Property() {
            String name = this.name();
            this.environmentVariableKey = HubServerConfigBuilder.HUB_SERVER_CONFIG_ENVIRONMENT_VARIABLE_PREFIX + name;
            this.propertyKey = this.environmentVariableKey.toLowerCase().replace("_", ".");
            String camelCaseName = WordUtils.capitalizeFully(name, '_').replace("_", "");
            this.builderPropertyName = StringUtils.uncapitalize((String)camelCaseName);
            this.builderPropertySetterName = "set" + camelCaseName;
        }

        public boolean isWithin(Set<String> keys) {
            return keys.contains(this.environmentVariableKey) || keys.contains(this.propertyKey);
        }

        public String getValueFrom(Map<String, String> values) {
            if (values.containsKey(this.propertyKey)) {
                return values.get(this.propertyKey);
            }
            return values.get(this.environmentVariableKey);
        }

        public String getEnvironmentVariableKey() {
            return this.environmentVariableKey;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public String getBuilderPropertyName() {
            return this.builderPropertyName;
        }

        public String getBuilderPropertySetterName() {
            return this.builderPropertySetterName;
        }
    }
}

