/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.util;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.examples.Expander;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CommonZipExpander {
    protected final IntLogger logger;

    public CommonZipExpander(IntLogger logger) {
        this.logger = logger;
    }

    public void expand(File sourceArchiveFile, File targetExpansionDirectory) throws IOException, ArchiveException, IntegrationException {
        this.beforeExpansion(sourceArchiveFile, targetExpansionDirectory);
        Expander expander = new Expander();
        try {
            expander.expand(sourceArchiveFile, targetExpansionDirectory);
        }
        catch (IOException | ArchiveException e) {
            this.logger.error("Couldn't extract the zip file - check the file's permissions: " + e.getMessage());
            throw e;
        }
        this.afterExpansion(sourceArchiveFile, targetExpansionDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(InputStream sourceArchiveStream, File targetExpansionDirectory) throws IOException, ArchiveException, IntegrationException {
        File tempZipFile = File.createTempFile("tmpzip", null);
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempZipFile);){
                IOUtils.copy((InputStream)sourceArchiveStream, (OutputStream)fileOutputStream);
            }
            if (!tempZipFile.exists() || tempZipFile.length() <= 0L) {
                throw new IntegrationException("The zip file was not created correctly. Please try again.");
            }
            this.expand(tempZipFile, targetExpansionDirectory);
        }
        finally {
            FileUtils.deleteQuietly((File)tempZipFile);
        }
    }

    public void beforeExpansion(File sourceArchiveFile, File targetExpansionDirectory) throws IntegrationException {
    }

    public void afterExpansion(File sourceArchiveFile, File targetExpansionDirectory) throws IntegrationException {
    }
}

