/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.credentials;

import com.synopsys.integration.encryption.PasswordDecrypter;
import com.synopsys.integration.encryption.PasswordEncrypter;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.util.Stringable;
import java.io.Serializable;
import java.util.Arrays;

public class Credentials
extends Stringable
implements Serializable {
    private static final long serialVersionUID = 4601465049752304687L;
    private final String username;
    private final String encryptedPassword;
    private final int actualPasswordLength;

    public Credentials(String username, String password) throws EncryptionException {
        this.username = username;
        this.actualPasswordLength = password == null ? 0 : password.length();
        this.encryptedPassword = PasswordEncrypter.encrypt(password);
    }

    public Credentials(String username, String encryptedPassword, int actualPasswordLength) {
        this.username = username;
        this.actualPasswordLength = actualPasswordLength;
        this.encryptedPassword = encryptedPassword;
    }

    public Credentials(String username, String password, boolean isEncrypted) throws EncryptionException {
        this.username = username;
        this.encryptedPassword = isEncrypted ? password : PasswordEncrypter.encrypt(password);
        this.actualPasswordLength = isEncrypted ? PasswordDecrypter.decrypt(password).length() : password.length();
    }

    public String getMaskedPassword() {
        char[] array = new char[this.actualPasswordLength];
        Arrays.fill(array, '*');
        return new String(array);
    }

    public String getDecryptedPassword() throws EncryptionException {
        return PasswordDecrypter.decrypt(this.encryptedPassword);
    }

    public String getUsername() {
        return this.username;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public int getActualPasswordLength() {
        return this.actualPasswordLength;
    }
}

