/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio;

import com.synopsys.integration.hub.bdio.BdioPropertyHelper;
import com.synopsys.integration.hub.bdio.model.BdioBillOfMaterials;
import com.synopsys.integration.hub.bdio.model.BdioComponent;
import com.synopsys.integration.hub.bdio.model.BdioCreationInfo;
import com.synopsys.integration.hub.bdio.model.BdioExternalIdentifier;
import com.synopsys.integration.hub.bdio.model.BdioProject;
import com.synopsys.integration.hub.bdio.model.SpdxCreator;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class BdioNodeFactory {
    private final BdioPropertyHelper bdioPropertyHelper;

    public BdioNodeFactory(BdioPropertyHelper bdioPropertyHelper) {
        this.bdioPropertyHelper = bdioPropertyHelper;
    }

    public BdioBillOfMaterials createBillOfMaterials(String codeLocationName, String projectName, String projectVersion) {
        BdioBillOfMaterials billOfMaterials = new BdioBillOfMaterials();
        billOfMaterials.id = String.format("uuid:%s", UUID.randomUUID());
        billOfMaterials.spdxName = StringUtils.isNotBlank((CharSequence)codeLocationName) ? codeLocationName : String.format("%s/%s Black Duck I/O Export", projectName, projectVersion);
        billOfMaterials.bdioSpecificationVersion = "1.1.0";
        billOfMaterials.creationInfo = new BdioCreationInfo();
        billOfMaterials.creationInfo.created = Instant.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        String version = "UnknownVersion";
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/blackducksoftware/integration/hub/bdio/version.txt");){
            version = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        billOfMaterials.creationInfo.addSpdxCreator(SpdxCreator.createToolSpdxCreator("IntegrationBdio", version));
        return billOfMaterials;
    }

    public BdioProject createProject(String projectName, String projectVersion, String bdioId, ExternalId externalId) {
        BdioExternalIdentifier externalIdentifier = this.bdioPropertyHelper.createExternalIdentifier(externalId);
        return this.createProject(projectName, projectVersion, bdioId, externalIdentifier);
    }

    public BdioProject createProject(String projectName, String projectVersion, String bdioId, BdioExternalIdentifier externalIdentifier) {
        BdioProject project = new BdioProject();
        project.id = bdioId;
        project.name = projectName;
        project.version = projectVersion;
        project.bdioExternalIdentifier = externalIdentifier;
        return project;
    }

    public BdioComponent createComponent(String componentName, String componentVersion, ExternalId externalId) {
        BdioExternalIdentifier externalIdentifier = this.bdioPropertyHelper.createExternalIdentifier(externalId);
        return this.createComponent(componentName, componentVersion, externalId.createBdioId(), externalIdentifier);
    }

    public BdioComponent createComponent(String componentName, String componentVersion, String bdioId, BdioExternalIdentifier externalIdentifier) {
        BdioComponent component = new BdioComponent();
        component.id = bdioId;
        component.name = componentName;
        component.version = componentVersion;
        component.bdioExternalIdentifier = externalIdentifier;
        return component;
    }
}

