/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner;

import com.synopsys.integration.blackduck.configuration.HubServerConfig;
import com.synopsys.integration.blackduck.signaturescanner.ScanJob;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanTarget;
import com.synopsys.integration.blackduck.signaturescanner.command.SnippetMatching;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ScanJobBuilder {
    public static final int DEFAULT_MEMORY_IN_MEGABYTES = 4096;
    public static final int MINIMUM_MEMORY_IN_MEGABYTES = 256;
    private File installDirectory;
    private File outputDirectory;
    private boolean cleanupOutput;
    private int scanMemoryInMegabytes = 4096;
    private boolean dryRun;
    private boolean debug;
    private boolean verbose = true;
    private String scanCliOpts;
    private String additionalScanArguments;
    private SnippetMatching snippetMatching;
    private URL blackDuckUrl;
    private String blackDuckUsername;
    private String blackDuckPassword;
    private String blackDuckApiToken;
    private boolean shouldUseProxy;
    private ProxyInfo proxyInfo;
    private boolean alwaysTrustServerCertificate;
    private String projectName;
    private String projectVersionName;
    private List<ScanTarget> scanTargets = new ArrayList<ScanTarget>();

    public ScanJob build() throws IllegalArgumentException {
        this.assertValid();
        return new ScanJob(this.installDirectory, this.outputDirectory, this.cleanupOutput, this.scanMemoryInMegabytes, this.dryRun, this.debug, this.verbose, this.scanCliOpts, this.additionalScanArguments, this.snippetMatching, this.blackDuckUrl, this.blackDuckUsername, this.blackDuckPassword, this.blackDuckApiToken, this.shouldUseProxy, this.proxyInfo, this.alwaysTrustServerCertificate, this.projectName, this.projectVersionName, this.scanTargets);
    }

    public void assertValid() throws IllegalArgumentException {
        String errorMessage = this.createErrorMessage();
        if (!errorMessage.isEmpty()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public boolean isValid() {
        return this.createErrorMessage().isEmpty();
    }

    public String createErrorMessage() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (this.scanTargets == null || this.scanTargets.size() < 1) {
            errorMessages.add("At least one target path must be provided.");
        } else {
            for (ScanTarget scanTarget : this.scanTargets) {
                try {
                    new File(scanTarget.getPath()).getCanonicalPath();
                }
                catch (IOException e) {
                    errorMessages.add(String.format("The target path: %s is not valid since its canonical path could not be determined: %s.", scanTarget.getPath(), e.getMessage()));
                }
                if (scanTarget.getExclusionPatterns() == null || scanTarget.getExclusionPatterns().size() <= 0) continue;
                for (String exclusionPattern : scanTarget.getExclusionPatterns()) {
                    if (!StringUtils.isNotBlank((CharSequence)exclusionPattern) || exclusionPattern.startsWith("/") && exclusionPattern.endsWith("/") && !exclusionPattern.contains("**")) continue;
                    errorMessages.add("The exclusion pattern: " + exclusionPattern + " is not valid. An exclusion pattern must start and end with a forward slash (/) and may not contain double asterisks (**).");
                }
            }
        }
        if (this.blackDuckUrl != null) {
            if (StringUtils.isBlank((CharSequence)this.blackDuckApiToken) && (StringUtils.isBlank((CharSequence)this.blackDuckUsername) || StringUtils.isBlank((CharSequence)this.blackDuckPassword))) {
                errorMessages.add("Either an api token or a username and password is required.");
            }
            if (this.shouldUseProxy && this.proxyInfo == null) {
                errorMessages.add("If a proxy should be used, the details must be provided.");
            }
        }
        if (this.scanMemoryInMegabytes < 256) {
            errorMessages.add(String.format("The minimum amount of memory for the scan is %d MB.", 256));
        }
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.projectName, this.projectVersionName}) && (StringUtils.isBlank((CharSequence)this.projectName) || StringUtils.isBlank((CharSequence)this.projectVersionName))) {
            errorMessages.add("Both projectName and projectVersionName must be provided or omitted together");
        }
        return StringUtils.join(errorMessages, (char)' ');
    }

    public ScanJobBuilder fromHubServerConfig(HubServerConfig hubServerConfig) throws EncryptionException {
        if (null == hubServerConfig) {
            this.shouldUseProxy = false;
            this.proxyInfo = ProxyInfo.NO_PROXY_INFO;
            this.blackDuckUrl = null;
            this.blackDuckUsername = null;
            this.blackDuckPassword = null;
            this.blackDuckApiToken = null;
            this.alwaysTrustServerCertificate = false;
        } else {
            this.shouldUseProxy = hubServerConfig.shouldUseProxyForHub();
            this.proxyInfo = hubServerConfig.getProxyInfo();
            this.blackDuckUrl = hubServerConfig.getHubUrl();
            if (hubServerConfig.usingApiToken()) {
                this.blackDuckApiToken = hubServerConfig.getApiToken();
            } else {
                this.blackDuckUsername = hubServerConfig.getGlobalCredentials().getUsername();
                this.blackDuckPassword = hubServerConfig.getGlobalCredentials().getDecryptedPassword();
            }
            this.alwaysTrustServerCertificate = hubServerConfig.isAlwaysTrustServerCertificate();
        }
        return this;
    }

    public ScanJobBuilder addTarget(ScanTarget scanTarget) {
        this.scanTargets.add(scanTarget);
        return this;
    }

    public ScanJobBuilder addTargets(List<ScanTarget> scanTargets) {
        this.scanTargets.addAll(scanTargets);
        return this;
    }

    public ScanJobBuilder projectAndVersionNames(String projectName, String projectVersionName) {
        this.projectName = projectName;
        this.projectVersionName = projectVersionName;
        return this;
    }

    public File getInstallDirectory() {
        return this.installDirectory;
    }

    public ScanJobBuilder installDirectory(File installDirectory) {
        this.installDirectory = installDirectory;
        return this;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public ScanJobBuilder outputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public boolean isCleanupOutput() {
        return this.cleanupOutput;
    }

    public ScanJobBuilder cleanupOutput(boolean cleanupOutput) {
        this.cleanupOutput = cleanupOutput;
        return this;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public ScanJobBuilder scanMemoryInMegabytes(int scanMemoryInMegabytes) {
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public ScanJobBuilder dryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ScanJobBuilder debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ScanJobBuilder verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public ScanJobBuilder scanCliOpts(String scanCliOpts) {
        this.scanCliOpts = scanCliOpts;
        return this;
    }

    public String getAdditionalScanArguments() {
        return this.additionalScanArguments;
    }

    public ScanJobBuilder additionalScanArguments(String additionalScanArguments) {
        this.additionalScanArguments = additionalScanArguments;
        return this;
    }

    public SnippetMatching getSnippetMatching() {
        return this.snippetMatching;
    }

    public ScanJobBuilder snippetMatching(SnippetMatching snippetMatching) {
        this.snippetMatching = snippetMatching;
        return this;
    }

    public URL getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public ScanJobBuilder blackDuckUrl(URL blackDuckUrl) {
        this.blackDuckUrl = blackDuckUrl;
        return this;
    }

    public String getBlackDuckUsername() {
        return this.blackDuckUsername;
    }

    public ScanJobBuilder blackDuckUsername(String blackDuckUsername) {
        this.blackDuckUsername = blackDuckUsername;
        return this;
    }

    public String getBlackDuckPassword() {
        return this.blackDuckPassword;
    }

    public ScanJobBuilder blackDuckPassword(String blackDuckPassword) {
        this.blackDuckPassword = blackDuckPassword;
        return this;
    }

    public String getBlackDuckApiToken() {
        return this.blackDuckApiToken;
    }

    public ScanJobBuilder blackDuckApiToken(String blackDuckApiToken) {
        this.blackDuckApiToken = blackDuckApiToken;
        return this;
    }

    public boolean isShouldUseProxy() {
        return this.shouldUseProxy;
    }

    public ScanJobBuilder shouldUseProxy(boolean shouldUseProxy) {
        this.shouldUseProxy = shouldUseProxy;
        return this;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public ScanJobBuilder proxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
        return this;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public ScanJobBuilder alwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersionName() {
        return this.projectVersionName;
    }

    public List<ScanTarget> getScanTargets() {
        return this.scanTargets;
    }

    public ScanJobBuilder simpleScanTargets(List<ScanTarget> scanTargets) {
        this.scanTargets = scanTargets;
        return this;
    }
}

