/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner;

import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommand;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanTarget;
import com.synopsys.integration.blackduck.signaturescanner.command.SnippetMatching;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.util.Stringable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ScanJob
extends Stringable {
    private final File signatureScannerInstallDirectory;
    private final File outputDirectory;
    private final boolean cleanupOutput;
    private final int scanMemoryInMegabytes;
    private final boolean dryRun;
    private final boolean debug;
    private final boolean verbose;
    private final String scanCliOpts;
    private final String additionalScanArguments;
    private final SnippetMatching snippetMatchingMode;
    private final URL blackDuckUrl;
    private final String blackDuckUsername;
    private final String blackDuckPassword;
    private final String blackDuckApiToken;
    private final boolean shouldUseProxy;
    private final ProxyInfo proxyInfo;
    private final boolean alwaysTrustServerCertificate;
    private final String projectName;
    private final String projectVersionName;
    private final List<ScanTarget> scanTargets;

    public ScanJob(File signatureScannerInstallDirectory, File outputDirectory, boolean cleanupOutput, int scanMemoryInMegabytes, boolean dryRun, boolean debug, boolean verbose, String scanCliOpts, String additionalScanArguments, SnippetMatching snippetMatchingMode, URL blackDuckUrl, String blackDuckUsername, String blackDuckPassword, String blackDuckApiToken, boolean shouldUseProxy, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate, String projectName, String projectVersionName, List<ScanTarget> scanTargets) {
        this.signatureScannerInstallDirectory = signatureScannerInstallDirectory;
        this.outputDirectory = outputDirectory;
        this.cleanupOutput = cleanupOutput;
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        this.dryRun = dryRun;
        this.debug = debug;
        this.verbose = verbose;
        this.scanCliOpts = scanCliOpts;
        this.additionalScanArguments = additionalScanArguments;
        this.snippetMatchingMode = snippetMatchingMode;
        this.blackDuckUrl = blackDuckUrl;
        this.blackDuckUsername = blackDuckUsername;
        this.blackDuckPassword = blackDuckPassword;
        this.blackDuckApiToken = blackDuckApiToken;
        this.shouldUseProxy = shouldUseProxy;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
        this.projectName = projectName;
        this.projectVersionName = projectVersionName;
        this.scanTargets = scanTargets;
    }

    public List<ScanCommand> createScanCommands(ScanPathsUtility scanPathsUtility) throws IOException, HubIntegrationException {
        boolean commandDryRun = this.blackDuckUrl == null || this.dryRun;
        boolean snippetMatching = SnippetMatching.SNIPPET_MATCHING == this.snippetMatchingMode || SnippetMatching.FULL_SNIPPET_MATCHING == this.snippetMatchingMode;
        boolean snippetMatchingOnly = SnippetMatching.SNIPPET_MATCHING_ONLY == this.snippetMatchingMode || SnippetMatching.FULL_SNIPPET_MATCHING_ONLY == this.snippetMatchingMode;
        boolean fullSnippetScan = SnippetMatching.FULL_SNIPPET_MATCHING == this.snippetMatchingMode || SnippetMatching.FULL_SNIPPET_MATCHING_ONLY == this.snippetMatchingMode;
        String commandScheme = null;
        String commandHost = null;
        int commandPort = 0;
        if (!commandDryRun) {
            commandScheme = this.blackDuckUrl.getProtocol();
            commandHost = this.blackDuckUrl.getHost();
            if (this.blackDuckUrl.getPort() > 0) {
                commandPort = this.blackDuckUrl.getPort();
            } else if (this.blackDuckUrl.getDefaultPort() > 0) {
                commandPort = this.blackDuckUrl.getDefaultPort();
            }
        }
        ArrayList<ScanCommand> scanCommands = new ArrayList<ScanCommand>();
        for (ScanTarget scanTarget : this.scanTargets) {
            File commandOutputDirectory = null;
            if (StringUtils.isNotBlank((CharSequence)scanTarget.getOutputDirectoryPath())) {
                commandOutputDirectory = scanTarget.isOutputDirectoryPathAbsolute() ? new File(scanTarget.getOutputDirectoryPath()) : new File(this.outputDirectory, scanTarget.getOutputDirectoryPath());
                commandOutputDirectory.mkdirs();
            } else {
                commandOutputDirectory = scanPathsUtility.createSpecificRunOutputDirectory(this.outputDirectory);
            }
            ScanCommand scanCommand = new ScanCommand(this.signatureScannerInstallDirectory, commandOutputDirectory, commandDryRun, this.shouldUseProxy, this.proxyInfo, this.scanCliOpts, this.scanMemoryInMegabytes, commandScheme, commandHost, this.blackDuckApiToken, this.blackDuckUsername, this.blackDuckPassword, commandPort, this.alwaysTrustServerCertificate, scanTarget.getCodeLocationName(), snippetMatching, snippetMatchingOnly, fullSnippetScan, scanTarget.getExclusionPatterns(), this.additionalScanArguments, scanTarget.getPath(), this.verbose, this.debug, this.projectName, this.projectVersionName);
            scanCommands.add(scanCommand);
        }
        return scanCommands;
    }

    public File getSignatureScannerInstallDirectory() {
        return this.signatureScannerInstallDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isCleanupOutput() {
        return this.cleanupOutput;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public String getAdditionalScanArguments() {
        return this.additionalScanArguments;
    }

    public SnippetMatching getSnippetMatchingMode() {
        return this.snippetMatchingMode;
    }

    public URL getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public String getBlackDuckUsername() {
        return this.blackDuckUsername;
    }

    public String getBlackDuckPassword() {
        return this.blackDuckPassword;
    }

    public String getBlackDuckApiToken() {
        return this.blackDuckApiToken;
    }

    public boolean isShouldUseProxy() {
        return this.shouldUseProxy;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersionName() {
        return this.projectVersionName;
    }

    public List<ScanTarget> getScanTargets() {
        return this.scanTargets;
    }
}

