/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.generated.component.ProjectRequest;
import com.synopsys.integration.blackduck.api.generated.component.ProjectVersionRequest;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectCloneCategoriesType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionDistributionType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionPhaseType;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.service.model.ProjectRequestValidator;
import com.synopsys.integration.builder.AbstractBuilder;
import com.synopsys.integration.rest.RestConstants;
import com.synopsys.integration.validator.AbstractValidator;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ProjectRequestBuilder
extends AbstractBuilder<ProjectRequest> {
    private String projectName;
    private String description;
    private Boolean projectLevelAdjustments;
    private String projectOwner;
    private Integer projectTier;
    private String distribution = ProjectVersionDistributionType.EXTERNAL.name();
    private String phase = ProjectVersionPhaseType.DEVELOPMENT.name();
    private String versionName;
    private String versionNickname;
    private String releaseComments;
    private String releasedOn;
    private List<ProjectCloneCategoriesType> cloneCategories;
    private String cloneFromReleaseUrl;

    public ProjectRequestBuilder() {
    }

    public ProjectRequestBuilder(String projectName, String versionName) {
        this.projectName = projectName;
        this.versionName = versionName;
    }

    @Override
    public AbstractValidator createValidator() {
        ProjectRequestValidator validator = new ProjectRequestValidator(this);
        return validator;
    }

    @Override
    public ProjectRequest buildObject() {
        ProjectVersionDistributionType distributionValue = ProjectVersionDistributionType.valueOf(this.distribution.toUpperCase());
        ProjectVersionPhaseType phaseValue = ProjectVersionPhaseType.valueOf(this.phase.toUpperCase());
        ProjectVersionRequest projectVersionRequest = new ProjectVersionRequest();
        projectVersionRequest.distribution = distributionValue;
        projectVersionRequest.phase = phaseValue;
        projectVersionRequest.versionName = this.versionName;
        projectVersionRequest.releaseComments = this.releaseComments;
        projectVersionRequest.cloneFromReleaseUrl = this.cloneFromReleaseUrl;
        if (StringUtils.isNotBlank((CharSequence)this.releasedOn)) {
            try {
                projectVersionRequest.releasedOn = RestConstants.parseDateString(this.releasedOn);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        projectVersionRequest.nickname = this.versionNickname;
        ProjectRequest projectRequest = new ProjectRequest();
        projectRequest.name = this.projectName;
        projectRequest.description = this.description;
        projectRequest.projectLevelAdjustments = this.projectLevelAdjustments;
        projectRequest.projectOwner = this.projectOwner;
        projectRequest.projectTier = this.projectTier;
        projectRequest.versionRequest = projectVersionRequest;
        projectRequest.cloneCategories = this.cloneCategories;
        return projectRequest;
    }

    public void setFromProject(ProjectView projectView) {
        this.cloneCategories = projectView.cloneCategories;
        this.description = projectView.description;
        this.projectName = projectView.name;
        this.projectLevelAdjustments = projectView.projectLevelAdjustments;
        this.projectOwner = projectView.projectOwner;
        this.projectTier = projectView.projectTier;
    }

    public void setFromProjectAndVersion(ProjectView projectView, ProjectVersionView projectVersionView) {
        this.setFromProject(projectView);
        this.distribution = projectVersionView.distribution.name();
        this.versionNickname = projectVersionView.nickname;
        this.phase = projectVersionView.phase.name();
        this.releaseComments = projectVersionView.releaseComments;
        if (projectVersionView.releasedOn != null) {
            this.releasedOn = RestConstants.formatDate(projectVersionView.releasedOn);
        }
        this.versionName = projectVersionView.versionName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProjectLevelAdjustments(Boolean projectLevelAdjustments) {
        this.projectLevelAdjustments = projectLevelAdjustments;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public void setProjectTier(Integer projectTier) {
        this.projectTier = projectTier;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public void setDistribution(ProjectVersionDistributionType distribution) {
        this.distribution = distribution.name();
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setPhase(ProjectVersionPhaseType phase) {
        this.phase = phase.name();
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setVersionNickname(String versionNickname) {
        this.versionNickname = versionNickname;
    }

    public void setReleaseComments(String releaseComments) {
        this.releaseComments = releaseComments;
    }

    public void setReleasedOn(String releasedOn) {
        this.releasedOn = releasedOn;
    }

    public void setCloneCategories(List<ProjectCloneCategoriesType> cloneCategories) {
        this.cloneCategories = cloneCategories;
    }

    public void setCloneFromReleaseUrl(String cloneFromReleaseUrl) {
        this.cloneFromReleaseUrl = cloneFromReleaseUrl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getProjectLevelAdjustments() {
        return this.projectLevelAdjustments;
    }

    public String getProjectOwner() {
        return this.projectOwner;
    }

    public Integer getProjectTier() {
        return this.projectTier;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getVersionNickname() {
        return this.versionNickname;
    }

    public String getReleaseComments() {
        return this.releaseComments;
    }

    public String getReleasedOn() {
        return this.releasedOn;
    }

    public List<ProjectCloneCategoriesType> getCloneCategories() {
        return this.cloneCategories;
    }

    public String getCloneFromReleaseUrl() {
        return this.cloneFromReleaseUrl;
    }
}

