/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HubFilter {
    private final Map<String, Set<String>> filterKeysToValues = new HashMap<String, Set<String>>();

    public static HubFilter createFilterWithMultipleValues(String key, List<String> values) {
        HubFilter hubFilter = new HubFilter();
        hubFilter.addFilter(key, values);
        return hubFilter;
    }

    public static HubFilter createFilterWithSingleValue(String key, String value) {
        HubFilter hubFilter = new HubFilter();
        hubFilter.addFilter(key, value);
        return hubFilter;
    }

    public void addFilter(String key, String value) {
        this.filterKeysToValues.computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    public void addFilter(String key, List<String> values) {
        this.filterKeysToValues.computeIfAbsent(key, k -> new HashSet()).addAll(values);
    }

    public List<String> getFilterParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        this.filterKeysToValues.forEach((filterKey, filterValues) -> filterValues.forEach(filterValue -> {
            String parameterString = String.format("%s:%s", filterKey, filterValue);
            parameters.add(parameterString);
        }));
        return parameters;
    }
}

