/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.response.AssignedProjectView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.generated.view.RoleAssignmentView;
import com.synopsys.integration.blackduck.api.generated.view.UserGroupView;
import com.synopsys.integration.blackduck.api.generated.view.UserView;
import com.synopsys.integration.blackduck.exception.DoesNotExistException;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class UserGroupService {
    private final IntLogger logger;
    private final HubService hubService;

    public UserGroupService(HubService hubService, IntLogger logger) {
        this.logger = logger;
        this.hubService = hubService;
    }

    public UserView getUserByUsername(String username) throws IntegrationException {
        List<UserView> allUsers = this.hubService.getAllResponses(ApiDiscovery.USERS_LINK_RESPONSE);
        for (UserView user : allUsers) {
            if (!user.userName.equalsIgnoreCase(username)) continue;
            return user;
        }
        throw new DoesNotExistException("This User does not exist. UserName : " + username);
    }

    public List<ProjectView> getProjectsForUser(String userName) throws IntegrationException {
        UserView user = this.getUserByUsername(userName);
        return this.getProjectsForUser(user);
    }

    public List<ProjectView> getProjectsForUser(UserView userView) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned projects for User: " + userView.userName);
        List<AssignedProjectView> assignedProjectViews = this.hubService.getAllResponses(userView, UserView.PROJECTS_LINK_RESPONSE);
        ArrayList<ProjectView> resolvedProjectViews = new ArrayList<ProjectView>();
        for (AssignedProjectView assigned : assignedProjectViews) {
            ProjectView project = this.hubService.getResponse(assigned.project, ProjectView.class);
            if (project == null) continue;
            resolvedProjectViews.add(project);
        }
        return resolvedProjectViews;
    }

    public List<RoleAssignmentView> getRolesForUser(String username) throws IntegrationException {
        UserView user = this.getUserByUsername(username);
        return this.getRolesForUser(user);
    }

    public List<RoleAssignmentView> getRolesForUser(UserView userView) throws IntegrationException {
        return this.hubService.getAllResponses(userView, UserView.ROLES_LINK_RESPONSE);
    }

    public List<RoleAssignmentView> getInheritedRolesForUser(String username) throws IntegrationException {
        UserView user = this.getUserByUsername(username);
        return this.getInheritedRolesForUser(user);
    }

    public List<RoleAssignmentView> getInheritedRolesForUser(UserView userView) throws IntegrationException {
        return this.hubService.getAllResponses(userView, UserView.INHERITED_ROLES_LINK_RESPONSE);
    }

    public List<RoleAssignmentView> getAllRolesForUser(String username) throws IntegrationException {
        UserView user = this.getUserByUsername(username);
        return this.getAllRolesForUser(user);
    }

    public List<RoleAssignmentView> getAllRolesForUser(UserView userView) throws IntegrationException {
        LinkedHashSet<RoleAssignmentView> roleSet = new LinkedHashSet<RoleAssignmentView>();
        roleSet.addAll(this.getRolesForUser(userView));
        roleSet.addAll(this.getInheritedRolesForUser(userView));
        return new ArrayList<RoleAssignmentView>(roleSet);
    }

    public UserGroupView getGroupByName(String groupName) throws IntegrationException {
        List<UserGroupView> allGroups = this.hubService.getAllResponses(ApiDiscovery.USERGROUPS_LINK_RESPONSE);
        for (UserGroupView group : allGroups) {
            if (!group.name.equalsIgnoreCase(groupName)) continue;
            return group;
        }
        throw new DoesNotExistException("This Group does not exist. Group name : " + groupName);
    }
}

