/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.component.ProjectRequest;
import com.synopsys.integration.blackduck.api.generated.component.ProjectVersionRequest;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.exception.DoesNotExistException;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.ProjectGetService;
import com.synopsys.integration.blackduck.service.model.ProjectVersionWrapper;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ProjectUpdateService
extends DataService {
    private final ProjectGetService projectGetService;

    public ProjectUpdateService(HubService hubService, IntLogger logger, ProjectGetService projectGetService) {
        super(hubService, logger);
        this.projectGetService = projectGetService;
    }

    public String createProject(ProjectRequest projectRequest) throws IntegrationException {
        String json = this.hubService.convertToJson(projectRequest);
        Request.Builder requestBuilder = RequestFactory.createCommonPostRequestBuilder(json);
        return this.hubService.executePostRequestAndRetrieveURL(ApiDiscovery.PROJECTS_LINK, requestBuilder);
    }

    public void updateProject(String projectUrl, ProjectRequest projectRequest) throws IntegrationException {
        String json = this.hubService.convertToJson(projectRequest);
        Request projectUpdateRequest = RequestFactory.createCommonPutRequestBuilder(json).uri(projectUrl).build();
        try {
            Response response = this.hubService.executeRequest(projectUpdateRequest);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public void deleteProject(String projectUrl) throws IntegrationException {
        Request deleteRequest = new Request.Builder(projectUrl).method(HttpMethod.DELETE).build();
        try {
            Response response = this.hubService.executeRequest(deleteRequest);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public String createProjectVersion(String projectVersionsUrl, ProjectVersionRequest projectVersionRequest) throws IntegrationException {
        String json = this.hubService.convertToJson(projectVersionRequest);
        Request request = RequestFactory.createCommonPostRequestBuilder(json).uri(projectVersionsUrl).build();
        return this.hubService.executePostRequestAndRetrieveURL(request);
    }

    public void updateProjectVersion(String projectVersionUrl, ProjectVersionRequest versionRequest) throws IntegrationException {
        String json = this.hubService.convertToJson(versionRequest);
        Request projectVersionUpdateRequest = RequestFactory.createCommonPutRequestBuilder(json).uri(projectVersionUrl).build();
        try {
            Response response = this.hubService.executeRequest(projectVersionUpdateRequest);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public void deleteProjectVersion(String projectVersionUrl) throws IntegrationException {
        Request deleteRequest = new Request.Builder(projectVersionUrl).method(HttpMethod.DELETE).build();
        try {
            Response response = this.hubService.executeRequest(deleteRequest);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public ProjectVersionWrapper syncProjectAndVersion(ProjectRequest projectRequest) throws IntegrationException {
        return this.syncProjectAndVersion(projectRequest, true);
    }

    public ProjectVersionWrapper syncProjectAndVersion(ProjectRequest projectRequest, boolean performUpdate) throws IntegrationException {
        ProjectView projectView;
        ProjectVersionView projectVersionView = null;
        try {
            projectView = this.projectGetService.getProjectByName(projectRequest.name);
            if (performUpdate) {
                String projectUrl = this.hubService.getHref(projectView);
                this.updateProject(projectUrl, projectRequest);
            }
        }
        catch (DoesNotExistException e) {
            String projectUrl = this.createProject(projectRequest);
            projectView = this.hubService.getResponse(projectUrl, ProjectView.class);
        }
        ProjectVersionRequest projectVersionRequest = projectRequest.versionRequest;
        if (projectVersionRequest != null && StringUtils.isNotBlank((CharSequence)projectVersionRequest.versionName)) {
            try {
                projectVersionView = this.projectGetService.getProjectVersion(projectView, projectVersionRequest.versionName);
                if (performUpdate) {
                    String projectVersionUrl = this.hubService.getHref(projectVersionView);
                    this.updateProjectVersion(projectVersionUrl, projectRequest.versionRequest);
                }
            }
            catch (DoesNotExistException e) {
                String projectVersionsUrl = this.hubService.getFirstLinkSafely(projectView, "versions");
                String projectVersionUrl = this.createProjectVersion(projectVersionsUrl, projectRequest.versionRequest);
                projectVersionView = this.hubService.getResponse(projectVersionUrl, ProjectVersionView.class);
            }
        }
        return new ProjectVersionWrapper(projectView, projectVersionView);
    }

    public void updateProjectAndVersion(String projectUri, String projectVersionUri, ProjectRequest projectRequest) throws IntegrationException {
        String json = this.hubService.convertToJson(projectRequest);
        Request projectUpdateRequest = RequestFactory.createCommonPutRequestBuilder(json).uri(projectUri).build();
        try {
            Response response = this.hubService.executeRequest(projectUpdateRequest);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
        this.updateProjectVersion(projectVersionUri, projectRequest.versionRequest);
    }
}

