/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.enumeration.NotificationType;
import com.synopsys.integration.blackduck.api.generated.view.NotificationUserView;
import com.synopsys.integration.blackduck.api.generated.view.NotificationView;
import com.synopsys.integration.blackduck.api.generated.view.UserView;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.model.HubFilter;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.request.Request;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class NotificationService
extends DataService {
    public NotificationService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
    }

    public List<NotificationView> getAllNotifications(Date startDate, Date endDate) throws IntegrationException {
        List<String> allKnownNotificationTypes = this.getAllKnownTypesToInclude();
        Request.Builder requestBuilder = this.createNotificationRequestBuilder(startDate, endDate, allKnownNotificationTypes);
        List<NotificationView> allNotificationItems = this.hubService.getResponses(ApiDiscovery.NOTIFICATIONS_LINK_RESPONSE, requestBuilder, true);
        return allNotificationItems;
    }

    public List<NotificationUserView> getAllUserNotifications(UserView user, Date startDate, Date endDate) throws IntegrationException {
        List<String> allKnownNotificationTypes = this.getAllKnownTypesToInclude();
        Request.Builder requestBuilder = this.createNotificationRequestBuilder(startDate, endDate, allKnownNotificationTypes);
        String userNotificationsUri = this.hubService.getFirstLink(user, "notifications");
        requestBuilder.uri(userNotificationsUri);
        List<NotificationUserView> allUserNotificationItems = this.hubService.getResponses(requestBuilder, NotificationUserView.class, true);
        return allUserNotificationItems;
    }

    public List<NotificationView> getFilteredNotifications(Date startDate, Date endDate, List<String> notificationTypesToInclude) throws IntegrationException {
        Request.Builder requestBuilder = this.createNotificationRequestBuilder(startDate, endDate, notificationTypesToInclude);
        List<NotificationView> allNotificationItems = this.hubService.getResponses(ApiDiscovery.NOTIFICATIONS_LINK_RESPONSE, requestBuilder, true);
        return allNotificationItems;
    }

    public List<NotificationUserView> getFilteredUserNotifications(UserView user, Date startDate, Date endDate, List<String> notificationTypesToInclude) throws IntegrationException {
        Request.Builder requestBuilder = this.createNotificationRequestBuilder(startDate, endDate, notificationTypesToInclude);
        String userNotificationsUri = this.hubService.getFirstLink(user, "notifications");
        requestBuilder.uri(userNotificationsUri);
        List<NotificationUserView> allUserNotificationItems = this.hubService.getResponses(requestBuilder, NotificationUserView.class, true);
        return allUserNotificationItems;
    }

    public Date getLatestNotificationDate() throws IntegrationException {
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(1, 0);
        List<NotificationView> notifications = this.hubService.getResponses(ApiDiscovery.NOTIFICATIONS_LINK_RESPONSE, requestBuilder, false);
        if (notifications.size() == 1) {
            return notifications.get((int)0).createdAt;
        }
        return new Date();
    }

    private Request.Builder createNotificationRequestBuilder(Date startDate, Date endDate, List<String> notificationTypesToInclude) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String startDateString = sdf.format(startDate);
        String endDateString = sdf.format(endDate);
        HubFilter hubFilter = HubFilter.createFilterWithMultipleValues("notificationType", notificationTypesToInclude);
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder().addQueryParameter("startDate", startDateString).addQueryParameter("endDate", endDateString);
        RequestFactory.addHubFilter(requestBuilder, hubFilter);
        return requestBuilder;
    }

    private List<String> getAllKnownTypesToInclude() {
        return Arrays.stream(NotificationType.values()).map(Enum::name).collect(Collectors.toList());
    }
}

