/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;

public class HubResponseTransformer {
    private final BlackduckRestConnection restConnection;
    private final JsonParser jsonParser;
    private final Gson gson;

    public HubResponseTransformer(BlackduckRestConnection restConnection, Gson gson, JsonParser jsonParser) {
        this.restConnection = restConnection;
        this.jsonParser = jsonParser;
        this.gson = gson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends HubResponse> T getResponse(Request request, Class<T> clazz) throws IntegrationException {
        try (Response response = this.restConnection.executeRequest(request);){
            String jsonResponse = response.getContentString();
            JsonObject jsonObject = this.jsonParser.parse(jsonResponse).getAsJsonObject();
            T t = this.getResponseAs(jsonObject, clazz);
            return t;
        }
        catch (IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    public <T extends HubResponse> T getResponseAs(JsonElement view, Class<T> clazz) {
        HubResponse hubItem = (HubResponse)this.gson.fromJson(view, clazz);
        hubItem.json = this.gson.toJson(view);
        return (T)hubItem;
    }

    public <T extends HubResponse> T getResponseAs(String view, Class<T> clazz) {
        HubResponse hubItem = (HubResponse)this.gson.fromJson(view, clazz);
        hubItem.json = view;
        return (T)hubItem;
    }
}

