/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.UriSingleResponse;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.api.generated.view.NotificationUserView;
import com.synopsys.integration.blackduck.api.generated.view.NotificationView;
import com.synopsys.integration.blackduck.notification.CommonNotificationView;
import com.synopsys.integration.blackduck.notification.CommonNotificationViewResults;
import com.synopsys.integration.blackduck.notification.NotificationDetailResult;
import com.synopsys.integration.blackduck.notification.NotificationDetailResults;
import com.synopsys.integration.blackduck.notification.content.detail.NotificationContentDetailFactory;
import com.synopsys.integration.blackduck.service.bucket.HubBucket;
import com.synopsys.integration.blackduck.service.bucket.HubBucketService;
import com.synopsys.integration.exception.IntegrationException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class CommonNotificationService {
    private final NotificationContentDetailFactory notificationContentDetailFactory;
    private final boolean oldestFirst;

    public CommonNotificationService(NotificationContentDetailFactory notificationContentDetailFactory, boolean oldestFirst) {
        this.notificationContentDetailFactory = notificationContentDetailFactory;
        this.oldestFirst = oldestFirst;
    }

    public List<CommonNotificationView> getCommonNotifications(List<NotificationView> notificationViews) {
        List<CommonNotificationView> commonStates = notificationViews.stream().map(view -> new CommonNotificationView((NotificationView)view)).collect(Collectors.toList());
        return commonStates;
    }

    public List<CommonNotificationView> getCommonUserNotifications(List<NotificationUserView> notificationUserViews) {
        List<CommonNotificationView> commonStates = notificationUserViews.stream().map(view -> new CommonNotificationView((NotificationUserView)view)).collect(Collectors.toList());
        return commonStates;
    }

    public CommonNotificationViewResults getCommonNotificationViewResults(List<CommonNotificationView> commonNotifications) {
        if (commonNotifications == null || commonNotifications.isEmpty()) {
            return new CommonNotificationViewResults(Collections.emptyList(), Optional.empty(), Optional.empty());
        }
        DatePair datePair = this.getLatestCreatedAtString(commonNotifications);
        return new CommonNotificationViewResults(commonNotifications, datePair.date, datePair.dateString);
    }

    public NotificationDetailResults getNotificationDetailResults(List<CommonNotificationView> commonNotifications) throws IntegrationException {
        if (commonNotifications == null || commonNotifications.isEmpty()) {
            return new NotificationDetailResults(Collections.emptyList(), Optional.empty(), Optional.empty());
        }
        List<NotificationDetailResult> sortedDetails = commonNotifications.stream().map(view -> this.notificationContentDetailFactory.generateContentDetails((CommonNotificationView)view)).collect(Collectors.toList());
        if (this.oldestFirst) {
            sortedDetails = sortedDetails.stream().sorted((result_1, result_2) -> result_1.getCreatedAt().compareTo(result_2.getCreatedAt())).collect(Collectors.toList());
        }
        DatePair datePair = this.getLatestCreatedAtString(commonNotifications);
        return new NotificationDetailResults(sortedDetails, datePair.date, datePair.dateString);
    }

    public void populateHubBucket(HubBucketService hubBucketService, HubBucket hubBucket, NotificationDetailResults notificationDetailResults) throws IntegrationException {
        ArrayList<UriSingleResponse<? extends HubResponse>> uriResponseList = new ArrayList<UriSingleResponse<? extends HubResponse>>();
        uriResponseList.addAll(notificationDetailResults.getAllLinks());
        hubBucketService.addToTheBucket(hubBucket, uriResponseList);
    }

    private DatePair getLatestCreatedAtString(List<CommonNotificationView> views) {
        List sortedViews = views.stream().sorted((left, right) -> right.getCreatedAt().compareTo(left.getCreatedAt())).collect(Collectors.toList());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date latestCreatedAtDate = ((CommonNotificationView)sortedViews.get(0)).getCreatedAt();
        String latestCreatedAtString = sdf.format(latestCreatedAtDate);
        return new DatePair(latestCreatedAtDate, latestCreatedAtString);
    }

    private static class DatePair {
        public final Optional<Date> date;
        public final Optional<String> dateString;

        public DatePair(Date date, String dateString) {
            this.date = Optional.ofNullable(date);
            this.dateString = Optional.ofNullable(dateString);
        }
    }
}

