/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.rest;

import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class CredentialsRestConnection
extends BlackduckRestConnection {
    private final String hubUsername;
    private final String hubPassword;

    public CredentialsRestConnection(IntLogger logger, URL baseUrl, String hubUsername, String hubPassword, int timeout, ProxyInfo proxyInfo) {
        super(logger, baseUrl, timeout, proxyInfo);
        this.hubUsername = hubUsername;
        this.hubPassword = hubPassword;
    }

    @Override
    public void populateHttpClientBuilder(HttpClientBuilder httpClientBuilder, RequestConfig.Builder defaultRequestConfigBuilder) throws IntegrationException {
        if (StringUtils.isNotBlank((CharSequence)this.hubUsername) && StringUtils.isNotBlank((CharSequence)this.hubPassword)) {
            httpClientBuilder.setDefaultCookieStore(new BasicCookieStore());
            defaultRequestConfigBuilder.setCookieSpec("default");
        }
    }

    @Override
    public void authenticateWithBlackduck() throws IntegrationException {
        URL securityUrl;
        try {
            securityUrl = new URL(this.getBaseUrl(), "j_spring_security_check");
        }
        catch (MalformedURLException e) {
            throw new IntegrationException("Error constructing the login URL: " + e.getMessage(), e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.hubUsername) && StringUtils.isNotBlank((CharSequence)this.hubPassword)) {
            ArrayList<BasicNameValuePair> bodyValues = new ArrayList<BasicNameValuePair>();
            bodyValues.add(new BasicNameValuePair("j_username", this.hubUsername));
            bodyValues.add(new BasicNameValuePair("j_password", this.hubPassword));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(bodyValues, Charsets.UTF_8);
            RequestBuilder requestBuilder = this.createRequestBuilder(HttpMethod.POST, null);
            requestBuilder.setCharset(Charsets.UTF_8);
            requestBuilder.setUri(securityUrl.toString());
            requestBuilder.setEntity((HttpEntity)entity);
            HttpUriRequest request = requestBuilder.build();
            this.logRequestHeaders(request);
            try (CloseableHttpResponse response = this.getClient().execute(request);){
                this.logResponseHeaders(response);
                int statusCode = response.getStatusLine().getStatusCode();
                String statusMessage = response.getStatusLine().getReasonPhrase();
                if (statusCode < 200 || statusCode >= 300) {
                    throw new IntegrationRestException(statusCode, statusMessage, String.format("Connection Error: %s %s", statusCode, statusMessage));
                }
                Header csrfToken = response.getFirstHeader("X-CSRF-TOKEN");
                if (csrfToken != null) {
                    this.addCommonRequestHeader("X-CSRF-TOKEN", csrfToken.getValue());
                } else {
                    this.logger.error("No CSRF token found when authenticating");
                }
            }
            catch (IOException e) {
                throw new IntegrationException(e.getMessage(), e);
            }
        }
    }
}

