#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from com.xebialabs.xlrelease.plugin.blackduck import RestConnectionHelper
from com.synopsys.integration.blackduck.api.generated.view import ProjectVersionView
from java.lang import String

class HubServicesHelper:
    BASE_URL = ""
    def __init__(self, params):
        if String(params.get('url')).endsWith('/'):
            self.BASE_URL = params.get('url')[:-1]
        else:
            self.BASE_URL = params.get('url')
        self.__server_params = params
        self.__connection_helper = RestConnectionHelper(
            self.__server_params['url'],
            self.__server_params['username'],
            self.__server_params['password'],
            self.__server_params['proxyHost'],
            self.__server_params['proxyPort'],
            self.__server_params['proxyUsername'],
            self.__server_params['proxyPassword'],
            self.__server_params['trustCertificate']
        )

    def get_project_view(self, project_name):
        project_service = self.get_hub_services_factory().createProjectService()
        return project_service.getProjectByName(project_name)

    def get_all_releases(self, project_view):
        return self.__connection_helper.createHubCompositeService().getAllReleases(self.get_project_id_by_view(project_view))

    def get_project_id_by_view(self, project_view):
        return self.__connection_helper.createHubCompositeService().getProjectIdByView(project_view)

    def get_project_version_id_by_view(self, version_view):
        return self.__connection_helper.createHubCompositeService().getProjectVersionIdByView(version_view)

    def get_project_url(self, project_view):
        return "{}/ui/projects/id:{}".format(self.BASE_URL, self.get_project_id_by_view(project_view))

    def get_project_version_url_by_id(self, id):
        return "{}/ui/versions/id:{}".format(self.BASE_URL, id)

    def get_hub_services_factory(self):
        hub_services_factory = self.__connection_helper.createHubServicesFactory()
        return hub_services_factory

    def get_risk_profile(self, project_name, version):
        hub_services_factory = self.get_hub_services_factory()
        project_service = hub_services_factory.createProjectService()
        project_view = project_service.getProjectByName(project_name)
        version_view = project_service.getProjectVersion(project_view, version)
        risk_profile_view = hub_services_factory.createHubService().getResponse(version_view, ProjectVersionView.RISKPROFILE_LINK_RESPONSE)
        return risk_profile_view, project_view, version_view
