/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.body;

import com.synopsys.integration.rest.body.BodyContent;
import com.synopsys.integration.rest.request.Request;
import java.io.File;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class MultipartBodyContent
implements BodyContent {
    private final Map<String, String> bodyContentStringMap;
    private final Map<String, File> bodyContentFileMap;

    public MultipartBodyContent(Map<String, File> bodyContentFileMap, Map<String, String> bodyContentStringMap) {
        this.bodyContentStringMap = bodyContentStringMap;
        this.bodyContentFileMap = bodyContentFileMap;
    }

    @Override
    public HttpEntity createEntity(Request request) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (Map.Entry<String, File> entry : this.getBodyContentFileMap().entrySet()) {
            builder.addBinaryBody(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getBodyContentStringMap().entrySet()) {
            this.addTextBody(builder, entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    public Map<String, String> getBodyContentStringMap() {
        return this.bodyContentStringMap;
    }

    public Map<String, File> getBodyContentFileMap() {
        return this.bodyContentFileMap;
    }

    private void addTextBody(MultipartEntityBuilder builder, String name, String value) {
        StringBody body = new StringBody(value, ContentType.DEFAULT_TEXT);
        FormBodyPart part = FormBodyPartBuilder.create((String)name, (ContentBody)body).build();
        part.getHeader().removeFields("Content-Type");
        builder.addPart(part);
    }
}

