/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.response.CurrentVersionView;
import com.synopsys.integration.blackduck.service.HubRegistrationService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.phonehome.PhoneHomeCallable;
import com.synopsys.integration.phonehome.PhoneHomeClient;
import com.synopsys.integration.phonehome.PhoneHomeRequestBody;
import com.synopsys.integration.phonehome.enums.ProductIdEnum;
import com.synopsys.integration.util.IntEnvironmentVariables;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class BlackDuckPhoneHomeCallable
extends PhoneHomeCallable {
    public static final int MAX_META_DATA_CHARACTERS = 1536;
    private final IntLogger logger;
    private final HubService hubService;
    private final HubRegistrationService hubRegistrationService;
    private final PhoneHomeRequestBody.Builder phoneHomeRequestBodyBuilder;

    public BlackDuckPhoneHomeCallable(IntLogger logger, PhoneHomeClient client, URL productURL, String artifactId, String artifactVersion, IntEnvironmentVariables intEnvironmentVariables, HubService hubService, HubRegistrationService hubRegistrationService) {
        super(logger, client, productURL, artifactId, artifactVersion, intEnvironmentVariables);
        this.logger = logger;
        this.hubService = hubService;
        this.hubRegistrationService = hubRegistrationService;
        this.phoneHomeRequestBodyBuilder = new PhoneHomeRequestBody.Builder();
    }

    public BlackDuckPhoneHomeCallable(IntLogger logger, PhoneHomeClient client, URL productURL, String artifactId, String artifactVersion, IntEnvironmentVariables intEnvironmentVariables, HubService hubService, HubRegistrationService hubRegistrationService, PhoneHomeRequestBody.Builder phoneHomeRequestBodyBuilder) {
        super(logger, client, productURL, artifactId, artifactVersion, intEnvironmentVariables);
        this.logger = logger;
        this.hubService = hubService;
        this.hubRegistrationService = hubRegistrationService;
        this.phoneHomeRequestBodyBuilder = phoneHomeRequestBodyBuilder;
    }

    @Override
    public PhoneHomeRequestBody.Builder createPhoneHomeRequestBodyBuilder() {
        try {
            CurrentVersionView currentVersion = this.hubService.getResponse(ApiDiscovery.CURRENT_VERSION_LINK_RESPONSE);
            String registrationId = null;
            try {
                registrationId = this.hubRegistrationService.getRegistrationId();
            }
            catch (IntegrationException integrationException) {
                // empty catch block
            }
            if (StringUtils.isBlank((CharSequence)registrationId)) {
                registrationId = "<unknown>";
            }
            this.phoneHomeRequestBodyBuilder.setCustomerId(registrationId);
            this.phoneHomeRequestBodyBuilder.setProductId(ProductIdEnum.HUB);
            this.phoneHomeRequestBodyBuilder.setProductVersion(currentVersion.version);
        }
        catch (Exception e) {
            this.logger.debug("Couldn't detail phone home request builder: " + e.getMessage());
        }
        return this.phoneHomeRequestBodyBuilder;
    }

    public boolean addMetaData(String key, String value) {
        if (this.charactersInMetaDataMap(key, value) < 1536) {
            this.phoneHomeRequestBodyBuilder.addToMetaData(key, value);
            return true;
        }
        return false;
    }

    private int charactersInMetaDataMap(String key, String value) {
        int mapEntryWrappingCharacters = 6;
        String mapAsString = this.phoneHomeRequestBodyBuilder.getMetaData().toString();
        return 6 + mapAsString.length() + key.length() + value.length();
    }
}

