/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.bucket;

import com.synopsys.integration.blackduck.api.UriSingleResponse;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.bucket.HubBucket;

public class HubBucketFillTask
implements Runnable {
    private final HubService hubService;
    private final HubBucket hubBucket;
    private final UriSingleResponse<? extends HubResponse> uriSingleResponse;

    public HubBucketFillTask(HubService hubService, HubBucket hubBucket, UriSingleResponse<? extends HubResponse> uriSingleResponse) {
        this.hubService = hubService;
        this.hubBucket = hubBucket;
        this.uriSingleResponse = uriSingleResponse;
    }

    @Override
    public void run() {
        if (!this.hubBucket.contains(this.uriSingleResponse.uri)) {
            try {
                HubResponse hubResponse = this.hubService.getResponse(this.uriSingleResponse);
                this.hubBucket.addValid(this.uriSingleResponse.uri, hubResponse);
            }
            catch (Exception e) {
                this.hubBucket.addError(this.uriSingleResponse.uri, e);
            }
        }
    }
}

