/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.synopsys.integration.blackduck.notification.content.detail.NotificationContentDetailFactory;
import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.blackduck.service.BinaryScannerService;
import com.synopsys.integration.blackduck.service.CodeLocationService;
import com.synopsys.integration.blackduck.service.CommonNotificationService;
import com.synopsys.integration.blackduck.service.ComponentService;
import com.synopsys.integration.blackduck.service.HubRegistrationService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.IssueService;
import com.synopsys.integration.blackduck.service.LicenseService;
import com.synopsys.integration.blackduck.service.NotificationService;
import com.synopsys.integration.blackduck.service.PolicyRuleService;
import com.synopsys.integration.blackduck.service.ProjectGetService;
import com.synopsys.integration.blackduck.service.ProjectService;
import com.synopsys.integration.blackduck.service.ProjectUpdateService;
import com.synopsys.integration.blackduck.service.ReportService;
import com.synopsys.integration.blackduck.service.ScanStatusService;
import com.synopsys.integration.blackduck.service.UserGroupService;
import com.synopsys.integration.blackduck.service.bucket.HubBucketService;
import com.synopsys.integration.blackduck.service.model.BlackDuckPhoneHomeCallable;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.phonehome.PhoneHomeCallable;
import com.synopsys.integration.phonehome.PhoneHomeClient;
import com.synopsys.integration.phonehome.PhoneHomeRequestBody;
import com.synopsys.integration.phonehome.PhoneHomeService;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.IntegrationEscapeUtil;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.impl.client.HttpClientBuilder;

public class HubServicesFactory {
    private final IntEnvironmentVariables intEnvironmentVariables = new IntEnvironmentVariables();
    private final Gson gson;
    private final JsonParser jsonParser;
    private final BlackduckRestConnection restConnection;
    private final IntLogger logger;

    public static Gson createDefaultGson() {
        return HubServicesFactory.createDefaultGsonBuilder().create();
    }

    public static GsonBuilder createDefaultGsonBuilder() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    }

    public static JsonParser createDefaultJsonParser() {
        return new JsonParser();
    }

    public HubServicesFactory(Gson gson, JsonParser jsonParser, BlackduckRestConnection restConnection, IntLogger logger) {
        this.gson = gson;
        this.jsonParser = jsonParser;
        this.restConnection = restConnection;
        this.logger = logger;
    }

    public void addEnvironmentVariable(String key, String value) {
        this.intEnvironmentVariables.put(key, value);
    }

    public void addEnvironmentVariables(Map<String, String> environmentVariables) {
        this.intEnvironmentVariables.putAll(environmentVariables);
    }

    public BinaryScannerService createBinaryScannerService() {
        return new BinaryScannerService(this.createHubService(), this.logger);
    }

    public PhoneHomeService createPhoneHomeService(ExecutorService executorService) {
        return new PhoneHomeService(this.logger, executorService);
    }

    public PhoneHomeCallable createBlackDuckPhoneHomeCallable(URL productURL, String artifactId, String artifactVersion) {
        BlackDuckPhoneHomeCallable phoneHomeCallable = new BlackDuckPhoneHomeCallable(this.logger, this.createPhoneHomeClient(), productURL, artifactId, artifactVersion, this.intEnvironmentVariables, this.createHubService(), this.createHubRegistrationService());
        return phoneHomeCallable;
    }

    public PhoneHomeCallable createBlackDuckPhoneHomeCallable(URL productURL, String artifactId, String artifactVersion, PhoneHomeRequestBody.Builder phoneHomeRequestBodyBuilder) {
        BlackDuckPhoneHomeCallable phoneHomeCallable = new BlackDuckPhoneHomeCallable(this.logger, this.createPhoneHomeClient(), productURL, artifactId, artifactVersion, this.intEnvironmentVariables, this.createHubService(), this.createHubRegistrationService(), phoneHomeRequestBodyBuilder);
        return phoneHomeCallable;
    }

    public PhoneHomeClient createPhoneHomeClient() {
        String googleAnalyticsTrackingId = "UA-116682967-1";
        HttpClientBuilder httpClientBuilder = this.restConnection.getClientBuilder();
        return new PhoneHomeClient("UA-116682967-1", this.logger, httpClientBuilder, this.gson);
    }

    public ReportService createReportService(long timeoutInMilliseconds) throws IntegrationException {
        return new ReportService(this.createHubService(), this.logger, this.createProjectService(), this.createIntegrationEscapeUtil(), timeoutInMilliseconds);
    }

    public PolicyRuleService createPolicyRuleService() {
        return new PolicyRuleService(this.createHubService());
    }

    public ScanStatusService createScanStatusService(long timeoutInMilliseconds) {
        return new ScanStatusService(this.createHubService(), this.logger, this.createProjectService(), this.createCodeLocationService(), timeoutInMilliseconds);
    }

    public NotificationService createNotificationService() {
        return new NotificationService(this.createHubService(), this.logger);
    }

    public CommonNotificationService createCommonNotificationService(NotificationContentDetailFactory notificationContentDetailFactory, boolean oldestFirst) {
        return new CommonNotificationService(notificationContentDetailFactory, oldestFirst);
    }

    public LicenseService createLicenseService() {
        return new LicenseService(this.createHubService(), this.logger, this.createComponentService());
    }

    public CodeLocationService createCodeLocationService() {
        return new CodeLocationService(this.createHubService(), this.logger);
    }

    public IntegrationEscapeUtil createIntegrationEscapeUtil() {
        return new IntegrationEscapeUtil();
    }

    public HubRegistrationService createHubRegistrationService() {
        return new HubRegistrationService(this.createHubService(), this.logger);
    }

    public HubService createHubService() {
        return new HubService(this.logger, this.restConnection, this.gson, this.jsonParser);
    }

    public ComponentService createComponentService() {
        return new ComponentService(this.createHubService(), this.logger);
    }

    public IssueService createIssueService() {
        return new IssueService(this.createHubService(), this.logger);
    }

    public ProjectService createProjectService() {
        HubService hubService = this.createHubService();
        ProjectGetService projectGetService = new ProjectGetService(hubService, this.logger);
        ProjectUpdateService projectUpdateService = new ProjectUpdateService(hubService, this.logger, projectGetService);
        return new ProjectService(hubService, this.logger, projectGetService, projectUpdateService, this.createComponentService());
    }

    public UserGroupService createUserGroupService() {
        return new UserGroupService(this.createHubService(), this.logger);
    }

    public HubBucketService createHubBucketService() {
        return new HubBucketService(this.createHubService(), this.logger);
    }

    public HubBucketService createHubBucketService(ExecutorService executorService) {
        return new HubBucketService(this.createHubService(), this.logger, executorService);
    }

    public BlackduckRestConnection getRestConnection() {
        return this.restConnection;
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public Gson getGson() {
        return this.gson;
    }

    public IntEnvironmentVariables getEnvironmentVariables() {
        return this.intEnvironmentVariables;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)RecursiveToStringStyle.JSON_STYLE);
    }
}

