/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.notification.content.detail;

import com.synopsys.integration.blackduck.api.UriSingleResponse;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.api.generated.view.ComponentVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentView;
import com.synopsys.integration.blackduck.api.generated.view.IssueView;
import com.synopsys.integration.blackduck.api.generated.view.PolicyRuleViewV2;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.VersionBomComponentView;
import com.synopsys.integration.util.Stringable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NotificationContentDetail
extends Stringable {
    private final String notificationGroup;
    private final String contentDetailKey;
    private final Optional<String> projectName;
    private final Optional<String> projectVersionName;
    private final Optional<UriSingleResponse<ProjectVersionView>> projectVersion;
    private final Optional<String> componentName;
    private final Optional<UriSingleResponse<ComponentView>> component;
    private final Optional<String> componentVersionName;
    private final Optional<UriSingleResponse<ComponentVersionView>> componentVersion;
    private final Optional<String> policyName;
    private final Optional<UriSingleResponse<PolicyRuleViewV2>> policy;
    private final Optional<String> componentVersionOriginName;
    private final Optional<UriSingleResponse<IssueView>> componentIssue;
    private final Optional<String> componentVersionOriginId;
    private final Optional<UriSingleResponse<VersionBomComponentView>> bomComponent;
    public static final String CONTENT_KEY_GROUP_BOM_EDIT = "bom_edit";
    public static final String CONTENT_KEY_GROUP_LICENSE = "license";
    public static final String CONTENT_KEY_GROUP_POLICY = "policy";
    public static final String CONTENT_KEY_GROUP_VULNERABILITY = "vulnerability";
    public static final String CONTENT_KEY_SEPARATOR = "|";

    public static NotificationContentDetail createDetail(String notificationGroup, Optional<String> projectName, Optional<String> projectVersionName, Optional<String> projectVersionUri, Optional<String> componentName, Optional<String> componentUri, Optional<String> componentVersionName, Optional<String> componentVersionUri, Optional<String> policyName, Optional<String> policyUri, Optional<String> componentVersionOriginName, Optional<String> componentIssueUri, Optional<String> componentVersionOriginId, Optional<String> bomComponent) {
        return new NotificationContentDetail(notificationGroup, projectName, projectVersionName, projectVersionUri, componentName, componentUri, componentVersionName, componentVersionUri, policyName, policyUri, componentVersionOriginName, componentIssueUri, componentVersionOriginId, bomComponent);
    }

    private NotificationContentDetail(String notificationGroup, Optional<String> projectName, Optional<String> projectVersionName, Optional<String> projectVersion, Optional<String> componentName, Optional<String> component, Optional<String> componentVersionName, Optional<String> componentVersion, Optional<String> policyName, Optional<String> policy, Optional<String> componentVersionOriginName, Optional<String> componentIssue, Optional<String> componentVersionOriginId, Optional<String> bomComponent) {
        this.notificationGroup = notificationGroup;
        this.projectName = projectName;
        this.projectVersionName = projectVersionName;
        this.projectVersion = this.createUriSingleResponse(projectVersion, ProjectVersionView.class);
        this.componentName = componentName;
        this.component = this.createUriSingleResponse(component, ComponentView.class);
        this.componentVersionName = componentVersionName;
        this.componentVersion = this.createUriSingleResponse(componentVersion, ComponentVersionView.class);
        this.policyName = policyName;
        this.policy = this.createUriSingleResponse(policy, PolicyRuleViewV2.class);
        this.componentVersionOriginName = componentVersionOriginName;
        this.componentIssue = this.createUriSingleResponse(componentIssue, IssueView.class);
        this.componentVersionOriginId = componentVersionOriginId;
        this.bomComponent = this.createUriSingleResponse(bomComponent, VersionBomComponentView.class);
        this.contentDetailKey = this.createContentDetailKey();
    }

    private <T extends HubResponse> Optional<UriSingleResponse<T>> createUriSingleResponse(Optional<String> uri, Class<T> responseClass) {
        if (uri.isPresent()) {
            return Optional.of(new UriSingleResponse<T>(uri.get(), responseClass));
        }
        return Optional.empty();
    }

    private String createContentDetailKey() {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(this.notificationGroup);
        keyBuilder.append(CONTENT_KEY_SEPARATOR);
        if (this.projectVersion.isPresent()) {
            keyBuilder.append(this.projectVersion.get().uri.hashCode());
        }
        keyBuilder.append(CONTENT_KEY_SEPARATOR);
        if (this.component.isPresent()) {
            keyBuilder.append(this.component.get().uri.hashCode());
        }
        keyBuilder.append(CONTENT_KEY_SEPARATOR);
        if (this.componentVersion.isPresent()) {
            keyBuilder.append(this.componentVersion.get().uri.hashCode());
        }
        keyBuilder.append(CONTENT_KEY_SEPARATOR);
        if (this.policy.isPresent()) {
            keyBuilder.append(this.policy.get().uri.hashCode());
            keyBuilder.append(CONTENT_KEY_SEPARATOR);
        }
        if (this.bomComponent.isPresent()) {
            keyBuilder.append(this.bomComponent.get().uri.hashCode());
        }
        keyBuilder.append(CONTENT_KEY_SEPARATOR);
        String key = keyBuilder.toString();
        return key;
    }

    public boolean hasComponentVersion() {
        return this.componentVersion.isPresent();
    }

    public boolean hasOnlyComponent() {
        return this.component.isPresent();
    }

    public boolean isPolicy() {
        return this.policy.isPresent();
    }

    public boolean isVulnerability() {
        return CONTENT_KEY_GROUP_VULNERABILITY.equals(this.notificationGroup);
    }

    public boolean isBomEdit() {
        return CONTENT_KEY_GROUP_BOM_EDIT.equals(this.notificationGroup);
    }

    public List<UriSingleResponse<? extends HubResponse>> getPresentLinks() {
        ArrayList<UriSingleResponse<? extends HubResponse>> presentLinks = new ArrayList<UriSingleResponse<? extends HubResponse>>();
        if (this.projectVersion.isPresent()) {
            presentLinks.add(this.projectVersion.get());
        }
        if (this.component.isPresent()) {
            presentLinks.add(this.component.get());
        }
        if (this.componentVersion.isPresent()) {
            presentLinks.add(this.componentVersion.get());
        }
        if (this.policy.isPresent()) {
            presentLinks.add(this.policy.get());
        }
        return presentLinks;
    }

    public String getNotificationGroup() {
        return this.notificationGroup;
    }

    public String getContentDetailKey() {
        return this.contentDetailKey;
    }

    public Optional<String> getProjectName() {
        return this.projectName;
    }

    public Optional<String> getProjectVersionName() {
        return this.projectVersionName;
    }

    public Optional<UriSingleResponse<ProjectVersionView>> getProjectVersion() {
        return this.projectVersion;
    }

    public Optional<String> getComponentName() {
        return this.componentName;
    }

    public Optional<UriSingleResponse<ComponentView>> getComponent() {
        return this.component;
    }

    public Optional<String> getComponentVersionName() {
        return this.componentVersionName;
    }

    public Optional<UriSingleResponse<ComponentVersionView>> getComponentVersion() {
        return this.componentVersion;
    }

    public Optional<String> getPolicyName() {
        return this.policyName;
    }

    public Optional<UriSingleResponse<PolicyRuleViewV2>> getPolicy() {
        return this.policy;
    }

    public Optional<String> getComponentVersionOriginName() {
        return this.componentVersionOriginName;
    }

    public Optional<UriSingleResponse<IssueView>> getComponentIssue() {
        return this.componentIssue;
    }

    public Optional<String> getComponentVersionOriginId() {
        return this.componentVersionOriginId;
    }

    public Optional<UriSingleResponse<VersionBomComponentView>> getBomComponent() {
        return this.bomComponent;
    }
}

